/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.util.Set;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryException;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountsSpi;

public final class MonetaryAmounts {
    private static MonetaryAmountsSpi monetaryAmountsSpi = Bootstrap.getService(MonetaryAmountsSpi.class);

    private MonetaryAmounts() {
    }

    public static <T extends MonetaryAmount> MonetaryAmountFactory<T> getAmountFactory(Class<T> amountType) {
        MonetaryAmountFactory<T> factory = monetaryAmountsSpi.getAmountFactory(amountType);
        if (factory == null) {
            throw new MonetaryException("No AmountFactory availablefor type: " + amountType.getName());
        }
        return factory;
    }

    public static MonetaryAmountFactory<?> getAmountFactory() {
        MonetaryAmountFactory<? extends MonetaryAmount> factory = monetaryAmountsSpi.getAmountFactory(MonetaryAmounts.getDefaultAmountType());
        if (factory == null) {
            throw new MonetaryException("No default AmountFactory available.");
        }
        return factory;
    }

    public static Class<? extends MonetaryAmount> getDefaultAmountType() {
        return monetaryAmountsSpi.getDefaultAmountType();
    }

    public static Set<Class<? extends MonetaryAmount>> getAmountTypes() {
        return monetaryAmountsSpi.getAmountTypes();
    }

    public static Class<? extends MonetaryAmount> queryAmountType(MonetaryContext requiredContext) {
        return monetaryAmountsSpi.queryAmountType(requiredContext);
    }
}

