/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractContext
implements Serializable {
    private static final long serialVersionUID = 5579720004786348255L;
    protected final Map<Class<?>, Map<Object, Object>> attributes = new HashMap();

    protected AbstractContext(AbstractBuilder builder) {
        this.attributes.putAll(builder.attributes);
    }

    protected final <T> T set(T attribute, Object key, Class<? extends T> type) {
        Map<Object, Object> typedAttrs = this.attributes.get(type);
        if (typedAttrs == null) {
            typedAttrs = new HashMap<Object, Object>();
            this.attributes.put(type, typedAttrs);
        }
        return (T)typedAttrs.put(key, attribute);
    }

    protected final <T> T set(T value) {
        return this.set(value, value.getClass(), value.getClass());
    }

    public <T> T getNamedAttribute(Class<T> type, Object key) {
        return this.getNamedAttribute(type, key, null);
    }

    public <T> T getNamedAttribute(Class<T> type, Object key, T defaultValue) {
        Object val;
        Map<Object, Object> typedAttrs = this.attributes.get(type);
        if (typedAttrs != null && (val = typedAttrs.get(key)) != null) {
            return (T)val;
        }
        return defaultValue;
    }

    public <T> T getAttribute(Class<T> type) {
        return this.getNamedAttribute(type, type);
    }

    public <T> T getAttribute(Class<T> type, T defaultValue) {
        T t = this.getAttribute(type);
        if (t == null) {
            return defaultValue;
        }
        return t;
    }

    public Set<Class<?>> getAttributeTypes() {
        return this.attributes.keySet();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractContext other = (AbstractContext)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [attributes=" + this.attributes + "]";
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        protected final Map<Class<?>, Map<Object, Object>> attributes = new HashMap();

        public AbstractBuilder() {
        }

        public AbstractBuilder(AbstractContext context) {
            Objects.requireNonNull(context);
            this.attributes.putAll(context.attributes);
        }

        public B set(Object value) {
            return this.set(value, value.getClass(), value.getClass());
        }

        public B remove(Class type) {
            return this.remove(type, type);
        }

        public B set(Object value, Object key) {
            return this.set(value, key, value.getClass());
        }

        public B remove(Class type, Object key) {
            Map<Object, Object> typedAttrs = this.attributes.get(type);
            if (typedAttrs != null) {
                this.attributes.remove(key);
            }
            return (B)this;
        }

        public <T> B set(T attribute, Object key, Class<? extends T> type) {
            Map<Object, Object> typedAttrs = this.attributes.get(type);
            if (typedAttrs == null) {
                typedAttrs = new HashMap<Object, Object>();
                this.attributes.put(type, typedAttrs);
            }
            typedAttrs.put(key, attribute);
            return (B)this;
        }

        public B setAll(AbstractContext context) {
            this.attributes.putAll(context.attributes);
            return (B)this;
        }

        public abstract AbstractContext create();

        public String toString() {
            return this.getClass().getSimpleName() + " [attributes=" + this.attributes + "]";
        }
    }
}

