/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.spi.ServiceProvider;

class DefaultServiceProvider
implements ServiceProvider {
    private final Map<Class, List<Object>> servicesLoaded = new HashMap<Class, List<Object>>();

    DefaultServiceProvider() {
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public <T> List<T> getServices(Class<T> serviceType) {
        List<Object> found = this.servicesLoaded.get(serviceType);
        if (found != null) {
            return found;
        }
        return this.loadServices(serviceType);
    }

    @Override
    public <T> T getService(Class<T> serviceType) {
        List<T> servicesFound = this.getServices(serviceType);
        if (servicesFound.isEmpty()) {
            return null;
        }
        return servicesFound.get(0);
    }

    private <T> List<T> loadServices(Class<T> serviceType) {
        ArrayList<T> services = new ArrayList<T>();
        try {
            for (T t : ServiceLoader.load(serviceType)) {
                services.add(t);
            }
            if (!this.servicesLoaded.containsKey(serviceType)) {
                ArrayList<T> previousServices = this.servicesLoaded.put(serviceType, services);
                return new ArrayList(previousServices != null ? previousServices : services);
            }
            return services;
        }
        catch (Exception e) {
            Logger.getLogger(DefaultServiceProvider.class.getName()).log(Level.WARNING, "Error loading services of type " + serviceType, e);
            return services;
        }
    }
}

