/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import com.sun.jmx.remote.generic.ClientAdmin;
import com.sun.jmx.remote.generic.ClientSynchroMessageConnection;
import com.sun.jmx.remote.generic.ServerAdmin;
import com.sun.jmx.remote.generic.SynchroMessageConnectionServer;
import com.sun.jmx.remote.opt.security.AdminClient;
import com.sun.jmx.remote.opt.security.AdminServer;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.util.Map;

public class DefaultConfig {
    public static final String SERVER_MAX_THREADS = "jmx.remote.x.server.max.threads";
    public static final String SERVER_MIN_THREADS = "jmx.remote.x.server.min.threads";
    public static final String REQUEST_WAITING_TIME = "jmx.remote.x.request.timeout";
    public static final String SERVER_SIDE_CONNECTING_TIMEOUT = "jmx.remote.x.server.side.connecting.timeout";
    public static final String SERVER_ADMIN = "com.sun.jmx.remote.server.admin";
    public static final String CLIENT_ADMIN = "com.sun.jmx.remote.client.admin";
    public static final String SYNCHRO_MESSAGE_CONNECTION_SERVER = "com.sun.jmx.remote.generic.synchro.server";
    public static final String CLIENT_SYNCHRO_MESSAGE_CONNECTION = "com.sun.jmx.remote.generic.synchro.client";
    public static final String TIMEOUT_FOR_CONNECTED_STATE = "jmx.remote.x.client.connected.state.timeout";
    public static final String SERVER_REUSE_ADDRESS = "jmx.remote.x.server.reuse.address";

    public static int getServerMaxThreads(Map map) {
        return (int)EnvHelp.getIntegerAttribute(map, SERVER_MAX_THREADS, 10L, 1L, Integer.MAX_VALUE);
    }

    public static int getServerMinThreads(Map map) {
        return (int)EnvHelp.getIntegerAttribute(map, SERVER_MIN_THREADS, 1L, 1L, Integer.MAX_VALUE);
    }

    public static long getRequestTimeout(Map map) {
        return EnvHelp.getIntegerAttribute(map, REQUEST_WAITING_TIME, Long.MAX_VALUE, 0L, Long.MAX_VALUE);
    }

    public static long getConnectingTimeout(Map map) {
        long l;
        try {
            l = EnvHelp.getIntegerAttribute(map, SERVER_SIDE_CONNECTING_TIMEOUT, 0L, 0L, Long.MAX_VALUE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            l = 0L;
        }
        return l;
    }

    public static ServerAdmin getServerAdmin(Map map) {
        ServerAdmin serverAdmin;
        Object v = map.get(SERVER_ADMIN);
        if (v == null) {
            serverAdmin = new AdminServer(map);
        } else if (v instanceof ServerAdmin) {
            serverAdmin = (ServerAdmin)v;
        } else {
            throw new IllegalArgumentException("The specified attribute \"com.sun.jmx.remote.server.admin\" is not a ServerAdmin object.");
        }
        return serverAdmin;
    }

    public static ClientAdmin getClientAdmin(Map map) {
        ClientAdmin clientAdmin;
        Object v = map.get(CLIENT_ADMIN);
        if (v == null) {
            clientAdmin = new AdminClient(map);
        } else if (v instanceof ClientAdmin) {
            clientAdmin = (ClientAdmin)v;
        } else {
            throw new IllegalArgumentException("The specified attribute \"com.sun.jmx.remote.client.admin\" is not a ClientAdmin object.");
        }
        return clientAdmin;
    }

    public static SynchroMessageConnectionServer getSynchroMessageConnectionServer(Map map) {
        SynchroMessageConnectionServer synchroMessageConnectionServer = null;
        if (map != null) {
            synchroMessageConnectionServer = (SynchroMessageConnectionServer)map.get(SYNCHRO_MESSAGE_CONNECTION_SERVER);
        }
        return synchroMessageConnectionServer;
    }

    public static ClientSynchroMessageConnection getClientSynchroMessageConnection(Map map) {
        ClientSynchroMessageConnection clientSynchroMessageConnection = null;
        if (map != null) {
            clientSynchroMessageConnection = (ClientSynchroMessageConnection)map.get(CLIENT_SYNCHRO_MESSAGE_CONNECTION);
        }
        return clientSynchroMessageConnection;
    }

    public static long getTimeoutForWaitConnectedState(Map map) {
        return EnvHelp.getIntegerAttribute(map, TIMEOUT_FOR_CONNECTED_STATE, 1000L, 1L, Long.MAX_VALUE);
    }

    public static boolean getServerReuseAddress(Map map) {
        Object v;
        if (map == null || (v = map.get(SERVER_REUSE_ADDRESS)) == null) {
            return false;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            return Boolean.valueOf((String)v);
        }
        throw new IllegalArgumentException("Attribute jmx.remote.x.server.reuse.address value must be Boolean or String.");
    }
}

