/*
 * Decompiled with CFR 0.152.
 */
package javax.json;

import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;

public interface JsonValue {
    public static final JsonObject EMPTY_JSON_OBJECT = Json.createObjectBuilder().build();
    public static final JsonArray EMPTY_JSON_ARRAY = Json.createArrayBuilder().build();
    public static final JsonValue NULL = new JsonValue(){

        @Override
        public ValueType getValueType() {
            return ValueType.NULL;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JsonValue) {
                return this.getValueType().equals((Object)((JsonValue)obj).getValueType());
            }
            return false;
        }

        public int hashCode() {
            return ValueType.NULL.hashCode();
        }

        @Override
        public String toString() {
            return "null";
        }
    };
    public static final JsonValue TRUE = new JsonValue(){

        @Override
        public ValueType getValueType() {
            return ValueType.TRUE;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JsonValue) {
                return this.getValueType().equals((Object)((JsonValue)obj).getValueType());
            }
            return false;
        }

        public int hashCode() {
            return ValueType.TRUE.hashCode();
        }

        @Override
        public String toString() {
            return "true";
        }
    };
    public static final JsonValue FALSE = new JsonValue(){

        @Override
        public ValueType getValueType() {
            return ValueType.FALSE;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JsonValue) {
                return this.getValueType().equals((Object)((JsonValue)obj).getValueType());
            }
            return false;
        }

        public int hashCode() {
            return ValueType.FALSE.hashCode();
        }

        @Override
        public String toString() {
            return "false";
        }
    };

    public ValueType getValueType();

    default public JsonObject asJsonObject() {
        return (JsonObject)JsonObject.class.cast(this);
    }

    default public JsonArray asJsonArray() {
        return (JsonArray)JsonArray.class.cast(this);
    }

    public String toString();

    public static enum ValueType {
        ARRAY,
        OBJECT,
        STRING,
        NUMBER,
        TRUE,
        FALSE,
        NULL;

    }
}

