/*
 * Decompiled with CFR 0.152.
 */
package javax.json;

import java.util.function.BiFunction;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.NodeReference;

public final class JsonPointer {
    private final String[] tokens;
    private final String jsonPointer;

    public JsonPointer(String jsonPointer) {
        this.jsonPointer = jsonPointer;
        this.tokens = jsonPointer.split("/", -1);
        if (!"".equals(this.tokens[0])) {
            throw new JsonException("A non-empty JSON pointer must begin with a '/'");
        }
        for (int i = 1; i < this.tokens.length; ++i) {
            String token = this.tokens[i];
            StringBuilder reftoken = new StringBuilder();
            for (int j = 0; j < token.length(); ++j) {
                int ch = token.charAt(j);
                if (ch == 126 && j < token.length() - 1) {
                    char ch1 = token.charAt(j + 1);
                    if (ch1 == '0') {
                        ch = 126;
                        ++j;
                    } else if (ch1 == '1') {
                        ch = 47;
                        ++j;
                    }
                }
                reftoken.append((char)ch);
            }
            this.tokens[i] = reftoken.toString();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != JsonPointer.class) {
            return false;
        }
        return this.jsonPointer.equals(((JsonPointer)obj).jsonPointer);
    }

    public int hashCode() {
        return this.jsonPointer.hashCode();
    }

    public JsonValue getValue(JsonStructure target) {
        NodeReference[] refs = this.getReferences(target);
        return refs[0].get();
    }

    public JsonStructure add(JsonStructure target, JsonValue value) {
        return this.execute(NodeReference::add, target, value);
    }

    public JsonStructure replace(JsonStructure target, JsonValue value) {
        return this.execute(NodeReference::replace, target, value);
    }

    public JsonStructure remove(JsonStructure target) {
        return this.execute((r, v) -> r.remove(), target, null);
    }

    public JsonObject add(JsonObject target, JsonValue value) {
        return (JsonObject)this.add((JsonStructure)target, value);
    }

    public JsonArray add(JsonArray target, JsonValue value) {
        return (JsonArray)this.add((JsonStructure)target, value);
    }

    public JsonObject replace(JsonObject target, JsonValue value) {
        return (JsonObject)this.replace((JsonStructure)target, value);
    }

    public JsonArray replace(JsonArray target, JsonValue value) {
        return (JsonArray)this.replace((JsonStructure)target, value);
    }

    public JsonObject remove(JsonObject target) {
        return (JsonObject)this.remove((JsonStructure)target);
    }

    public JsonArray remove(JsonArray target) {
        return (JsonArray)this.remove((JsonStructure)target);
    }

    private JsonStructure execute(BiFunction<NodeReference, JsonValue, JsonStructure> op, JsonStructure target, JsonValue value) {
        NodeReference[] refs = this.getReferences(target);
        JsonStructure result = op.apply(refs[0], value);
        for (int i = 1; i < refs.length; ++i) {
            result = refs[i].replace(result);
        }
        return result;
    }

    private NodeReference[] getReferences(JsonStructure target) {
        if (this.tokens.length == 1) {
            NodeReference[] references = new NodeReference[]{NodeReference.of(target)};
            return references;
        }
        NodeReference[] references = new NodeReference[this.tokens.length - 1];
        JsonValue value = target;
        int s = this.tokens.length;
        block4: for (int i = 1; i < s; ++i) {
            switch (value.getValueType()) {
                case OBJECT: {
                    JsonObject object = (JsonObject)value;
                    references[s - i - 1] = NodeReference.of(object, this.tokens[i]);
                    if (i >= s - 1 || (value = (JsonValue)object.get(this.tokens[i])) != null) continue block4;
                    throw new JsonException("The JSON object " + object + " contains no mapping " + " for the name " + this.tokens[i]);
                }
                case ARRAY: {
                    int index = JsonPointer.getIndex(this.tokens[i]);
                    JsonArray array = (JsonArray)value;
                    references[s - i - 1] = NodeReference.of(array, index);
                    if (i >= s - 1 || index == -1) continue block4;
                    value = (JsonValue)array.get(index);
                    continue block4;
                }
                default: {
                    throw new JsonException("The reference value in a Json pointer must be a Json object or a Json array");
                }
            }
        }
        return references;
    }

    private static int getIndex(String token) {
        if (token == null || token.length() == 0) {
            throw new JsonException("Array index format error");
        }
        if (token.equals("-")) {
            return -1;
        }
        if (token.equals("0")) {
            return 0;
        }
        if (token.charAt(0) == '+' || token.charAt(0) == '-') {
            throw new JsonException("Array index format error");
        }
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException ex) {
            throw new JsonException("Illegal integer format ", ex);
        }
    }
}

