/*
 * Decompiled with CFR 0.152.
 */
package javax.json;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class JsonMergePatch {
    public static JsonValue mergePatch(JsonValue target, JsonValue patch) {
        if (patch.getValueType() != JsonValue.ValueType.OBJECT) {
            return patch;
        }
        if (target.getValueType() != JsonValue.ValueType.OBJECT) {
            target = JsonValue.EMPTY_JSON_OBJECT;
        }
        JsonObject targetJsonObject = target.asJsonObject();
        JsonObjectBuilder builder = Json.createObjectBuilder(targetJsonObject);
        patch.asJsonObject().forEach((key, value) -> {
            if (value == JsonValue.NULL) {
                if (targetJsonObject.containsKey(key)) {
                    builder.remove((String)key);
                }
            } else if (targetJsonObject.containsKey(key)) {
                builder.add((String)key, JsonMergePatch.mergePatch((JsonValue)targetJsonObject.get(key), value));
            } else {
                builder.add((String)key, JsonMergePatch.mergePatch(JsonValue.EMPTY_JSON_OBJECT, value));
            }
        });
        return builder.build();
    }

    public static JsonValue diff(JsonValue source, JsonValue target) {
        if (source.getValueType() != JsonValue.ValueType.OBJECT || target.getValueType() != JsonValue.ValueType.OBJECT) {
            return target;
        }
        JsonObject s = (JsonObject)source;
        JsonObject t = (JsonObject)target;
        JsonObjectBuilder builder = Json.createObjectBuilder();
        s.forEach((key, value) -> {
            if (t.containsKey(key)) {
                if (!value.equals(t.get(key))) {
                    builder.add((String)key, JsonMergePatch.diff(value, (JsonValue)t.get(key)));
                }
            } else {
                builder.addNull((String)key);
            }
        });
        t.forEach((key, value) -> {
            if (!s.containsKey(key)) {
                builder.add((String)key, (JsonValue)value);
            }
        });
        return builder.build();
    }
}

