/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jsonapi;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Iterator;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilder;
import javax.json.JsonConfiguration;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.stream.JsonParser;

public class JsonReaderImpl {
    private final JsonParser parser;
    private boolean readDone;

    public JsonReaderImpl(Reader reader) {
        this.parser = Json.createParser(reader);
    }

    public JsonReaderImpl(Reader reader, JsonConfiguration config) {
        this.parser = Json.createParser(reader, config);
    }

    public JsonReaderImpl(InputStream in) {
        this.parser = Json.createParser(in);
    }

    public JsonReaderImpl(InputStream in, String encoding) {
        this.parser = Json.createParser(in, encoding);
    }

    public JsonReaderImpl(InputStream in, String encoding, JsonConfiguration config) {
        this.parser = Json.createParser(in, encoding, config);
    }

    public JsonObject readObject() {
        if (this.readDone) {
            throw new IllegalStateException("read/readObject/readArray/close method is already called.");
        }
        this.readDone = true;
        Iterator<JsonParser.Event> it = this.parser.iterator();
        if (it.hasNext()) {
            JsonParser.Event e = (JsonParser.Event)((Object)it.next());
            if (e == JsonParser.Event.START_OBJECT) {
                return (JsonObject)this.read(it, e);
            }
            if (e == JsonParser.Event.START_ARRAY) {
                throw new JsonException("Cannot read JSON object, found JSON array");
            }
            throw new JsonException("Cannot read JSON object, parsing error. Parsing Event=" + (Object)((Object)e));
        }
        throw new JsonException("Cannot read JSON object, possibly empty stream");
    }

    public JsonArray readArray() {
        if (this.readDone) {
            throw new IllegalStateException("read/readObject/readArray/close method is already called.");
        }
        this.readDone = true;
        Iterator<JsonParser.Event> it = this.parser.iterator();
        if (it.hasNext()) {
            JsonParser.Event e = (JsonParser.Event)((Object)it.next());
            if (e == JsonParser.Event.START_ARRAY) {
                return (JsonArray)this.read(it, e);
            }
            if (e == JsonParser.Event.START_OBJECT) {
                throw new JsonException("Cannot read JSON array, found JSON object");
            }
            throw new JsonException("Cannot read JSON array, parsing error. Parsing Event=" + (Object)((Object)e));
        }
        throw new JsonException("Cannot read JSON array, possibly empty stream");
    }

    public JsonStructure read() {
        if (this.readDone) {
            throw new IllegalStateException("read/readObject/readArray/close method is already called.");
        }
        this.readDone = true;
        Iterator<JsonParser.Event> it = this.parser.iterator();
        if (it.hasNext()) {
            JsonParser.Event e = (JsonParser.Event)((Object)it.next());
            if (e == JsonParser.Event.START_ARRAY || e == JsonParser.Event.START_OBJECT) {
                return this.read(it, e);
            }
            throw new JsonException("Cannot read JSON, parsing error. Parsing Event=" + (Object)((Object)e));
        }
        throw new JsonException("Cannot read JSON, possibly empty stream");
    }

    private JsonStructure read(Iterator<JsonParser.Event> it, JsonParser.Event firstEvent) {
        JsonObjectBuilder<JsonObjectBuilder<JsonBuilder.JsonBuildable<JsonObject>>> builder = new JsonBuilder();
        String key = null;
        JsonParser.Event e = firstEvent;
        while (true) {
            switch (e) {
                case START_ARRAY: {
                    if (builder instanceof JsonBuilder) {
                        builder = ((JsonBuilder)((Object)builder)).beginArray();
                        break;
                    }
                    if (builder instanceof JsonArrayBuilder) {
                        builder = ((JsonArrayBuilder)((Object)builder)).beginArray();
                        break;
                    }
                    builder = builder.beginArray(key);
                    break;
                }
                case START_OBJECT: {
                    if (builder instanceof JsonBuilder) {
                        builder = ((JsonBuilder)((Object)builder)).beginObject();
                        break;
                    }
                    if (builder instanceof JsonArrayBuilder) {
                        builder = ((JsonArrayBuilder)((Object)builder)).beginObject();
                        break;
                    }
                    builder = builder.beginObject(key);
                    break;
                }
                case KEY_NAME: {
                    key = this.parser.getString();
                    break;
                }
                case VALUE_STRING: {
                    String string = this.parser.getString();
                    if (builder instanceof JsonArrayBuilder) {
                        ((JsonArrayBuilder)((Object)builder)).add(string);
                        break;
                    }
                    builder.add(key, string);
                    break;
                }
                case VALUE_NUMBER: {
                    BigDecimal bd = new BigDecimal(this.parser.getString());
                    if (builder instanceof JsonArrayBuilder) {
                        ((JsonArrayBuilder)((Object)builder)).add(bd);
                        break;
                    }
                    builder.add(key, bd);
                    break;
                }
                case VALUE_TRUE: {
                    if (builder instanceof JsonArrayBuilder) {
                        ((JsonArrayBuilder)((Object)builder)).add(true);
                        break;
                    }
                    ((JsonObjectBuilder)builder).add(key, true);
                    break;
                }
                case VALUE_FALSE: {
                    if (builder instanceof JsonArrayBuilder) {
                        ((JsonArrayBuilder)((Object)builder)).add(false);
                        break;
                    }
                    ((JsonObjectBuilder)builder).add(key, false);
                    break;
                }
                case VALUE_NULL: {
                    if (builder instanceof JsonArrayBuilder) {
                        ((JsonArrayBuilder)((Object)builder)).addNull();
                        break;
                    }
                    ((JsonObjectBuilder)builder).addNull(key);
                    break;
                }
                case END_OBJECT: {
                    builder = ((JsonObjectBuilder)builder).endObject();
                    break;
                }
                case END_ARRAY: {
                    builder = ((JsonArrayBuilder)((Object)builder)).endArray();
                }
            }
            if (!it.hasNext()) break;
            e = it.next();
        }
        return ((JsonBuilder.JsonBuildable)((Object)builder)).build();
    }

    public void close() {
        this.readDone = true;
        this.parser.close();
    }
}

