/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jsonapi;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonNumber;
import javax.json.JsonValue;

public final class JsonNumberImpl
implements JsonNumber {
    private final BigDecimal bigDecimal;
    private static final BigDecimal INT_MIN_VALUE = new BigDecimal(Integer.MIN_VALUE);
    private static final BigDecimal INT_MAX_VALUE = new BigDecimal(Integer.MAX_VALUE);
    private static final BigDecimal LONG_MIN_VALUE = new BigDecimal(Long.MIN_VALUE);
    private static final BigDecimal LONG_MAX_VALUE = new BigDecimal(Long.MAX_VALUE);

    public JsonNumberImpl(String value) {
        this.bigDecimal = new BigDecimal(value);
    }

    public JsonNumberImpl(int value) {
        this.bigDecimal = new BigDecimal(value);
    }

    public JsonNumberImpl(long value) {
        this.bigDecimal = new BigDecimal(value);
    }

    public JsonNumberImpl(BigInteger value) {
        this.bigDecimal = new BigDecimal(value);
    }

    public JsonNumberImpl(double value) {
        this.bigDecimal = BigDecimal.valueOf(value);
    }

    public JsonNumberImpl(BigDecimal value) {
        this.bigDecimal = value;
    }

    @Override
    public JsonNumber.JsonNumberType getNumberType() {
        if (this.bigDecimal.scale() != 0) {
            return JsonNumber.JsonNumberType.BIG_DECIMAL;
        }
        if (this.bigDecimal.compareTo(INT_MIN_VALUE) >= 0 && this.bigDecimal.compareTo(INT_MAX_VALUE) <= 0) {
            return JsonNumber.JsonNumberType.INT;
        }
        if (this.bigDecimal.compareTo(LONG_MIN_VALUE) >= 0 && this.bigDecimal.compareTo(LONG_MAX_VALUE) <= 0) {
            return JsonNumber.JsonNumberType.LONG;
        }
        return JsonNumber.JsonNumberType.BIG_DECIMAL;
    }

    @Override
    public int getIntValue() {
        return this.bigDecimal.intValue();
    }

    @Override
    public int getIntValueExact() {
        return this.bigDecimal.intValueExact();
    }

    @Override
    public long getLongValue() {
        return this.bigDecimal.longValue();
    }

    @Override
    public long getLongValueExact() {
        return this.bigDecimal.longValueExact();
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return this.bigDecimal.toBigInteger();
    }

    @Override
    public BigInteger getBigIntegerValueExact() {
        return this.bigDecimal.toBigIntegerExact();
    }

    @Override
    public double getDoubleValue() {
        return this.bigDecimal.doubleValue();
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        return this.bigDecimal;
    }

    @Override
    public JsonValue.JsonValueType getValueType() {
        return JsonValue.JsonValueType.NUMBER;
    }

    public int hashCode() {
        return this.bigDecimal.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsonNumberImpl)) {
            return false;
        }
        JsonNumberImpl other = (JsonNumberImpl)obj;
        return this.bigDecimal.equals(other.bigDecimal);
    }

    @Override
    public String toString() {
        return this.bigDecimal.toString();
    }
}

