/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.beans;

import com.sun.faces.config.DigesterFactory;
import com.sun.faces.config.beans.ApplicationBean;
import com.sun.faces.config.beans.ComponentBean;
import com.sun.faces.config.beans.ConverterBean;
import com.sun.faces.config.beans.FactoryBean;
import com.sun.faces.config.beans.LifecycleBean;
import com.sun.faces.config.beans.ManagedBeanBean;
import com.sun.faces.config.beans.NavigationRuleBean;
import com.sun.faces.config.beans.ReferencedBeanBean;
import com.sun.faces.config.beans.RenderKitBean;
import com.sun.faces.config.beans.ValidatorBean;
import com.sun.faces.util.ToolsUtil;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FacesConfigBean {
    private static final Logger logger = ToolsUtil.getLogger("javax.enterprise.resource.webcontainer.jsf.config.beans");
    private ApplicationBean application;
    private FactoryBean factory;
    private LifecycleBean lifecycle;
    private Map<String, ComponentBean> components = new TreeMap<String, ComponentBean>();
    private Map<String, ConverterBean> convertersByClass = new TreeMap<String, ConverterBean>();
    private Map<String, ConverterBean> convertersById = new TreeMap<String, ConverterBean>();
    private Map<String, ManagedBeanBean> managedBeans = new TreeMap<String, ManagedBeanBean>();
    private Map<String, NavigationRuleBean> navigationRules = new TreeMap<String, NavigationRuleBean>();
    private Map<String, ReferencedBeanBean> referencedBeans = new TreeMap<String, ReferencedBeanBean>();
    private Map<String, RenderKitBean> renderKits = new TreeMap<String, RenderKitBean>();
    private Map<String, ValidatorBean> validators = new TreeMap<String, ValidatorBean>();

    public ApplicationBean getApplication() {
        return this.application;
    }

    public void setApplication(ApplicationBean application) {
        this.application = application;
    }

    public FactoryBean getFactory() {
        return this.factory;
    }

    public void setFactory(FactoryBean factory) {
        this.factory = factory;
    }

    public LifecycleBean getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(LifecycleBean lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void addComponent(ComponentBean descriptor) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "addComponent(" + descriptor.getComponentType() + ")");
        }
        this.components.put(descriptor.getComponentType(), descriptor);
    }

    public ComponentBean getComponent(String componentType) {
        return this.components.get(componentType);
    }

    public ComponentBean[] getComponents() {
        ComponentBean[] results = new ComponentBean[this.components.size()];
        return this.components.values().toArray(results);
    }

    public void removeComponent(ComponentBean descriptor) {
        this.components.remove(descriptor.getComponentType());
    }

    public void addConverter(ConverterBean descriptor) {
        if (descriptor.getConverterId() != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "addConverterById(" + descriptor.getConverterId() + ")");
            }
            this.convertersById.put(descriptor.getConverterId(), descriptor);
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "addConverterByClass(" + descriptor.getConverterForClass() + ")");
            }
            this.convertersByClass.put(descriptor.getConverterForClass(), descriptor);
        }
    }

    public ConverterBean getConverterByClass(String converterForClass) {
        return this.convertersByClass.get(converterForClass);
    }

    public ConverterBean getConverterById(String converterId) {
        return this.convertersById.get(converterId);
    }

    public ConverterBean[] getConvertersByClass() {
        ConverterBean[] results = new ConverterBean[this.convertersByClass.size()];
        return this.convertersByClass.values().toArray(results);
    }

    public ConverterBean[] getConvertersById() {
        ConverterBean[] results = new ConverterBean[this.convertersById.size()];
        return this.convertersById.values().toArray(results);
    }

    public void removeConverter(ConverterBean descriptor) {
        if (descriptor.getConverterId() != null) {
            this.convertersById.remove(descriptor.getConverterId());
        } else {
            this.convertersByClass.remove(descriptor.getConverterForClass());
        }
    }

    public void addManagedBean(ManagedBeanBean descriptor) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "addManagedBean(" + descriptor.getManagedBeanName() + ")");
        }
        this.managedBeans.put(descriptor.getManagedBeanName(), descriptor);
    }

    public ManagedBeanBean getManagedBean(String name) {
        return this.managedBeans.get(name);
    }

    public ManagedBeanBean[] getManagedBeans() {
        ManagedBeanBean[] results = new ManagedBeanBean[this.managedBeans.size()];
        return this.managedBeans.values().toArray(results);
    }

    public void removeManagedBean(ManagedBeanBean descriptor) {
        this.managedBeans.remove(descriptor.getManagedBeanName());
    }

    public void addNavigationRule(NavigationRuleBean descriptor) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "addNavigationRule(" + descriptor.getFromViewId() + ")");
        }
        this.navigationRules.put(descriptor.getFromViewId(), descriptor);
    }

    public NavigationRuleBean getNavigationRule(String fromViewId) {
        return this.navigationRules.get(fromViewId);
    }

    public NavigationRuleBean[] getNavigationRules() {
        NavigationRuleBean[] results = new NavigationRuleBean[this.navigationRules.size()];
        return this.navigationRules.values().toArray(results);
    }

    public void removeNavigationRule(NavigationRuleBean descriptor) {
        this.navigationRules.remove(descriptor.getFromViewId());
    }

    public void addReferencedBean(ReferencedBeanBean descriptor) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "addReferencedBean(" + descriptor.getReferencedBeanName() + ")");
        }
        this.referencedBeans.put(descriptor.getReferencedBeanName(), descriptor);
    }

    public ReferencedBeanBean getReferencedBean(String name) {
        return this.referencedBeans.get(name);
    }

    public ReferencedBeanBean[] getReferencedBeans() {
        ReferencedBeanBean[] results = new ReferencedBeanBean[this.referencedBeans.size()];
        return this.referencedBeans.values().toArray(results);
    }

    public void removeReferencedBean(ReferencedBeanBean descriptor) {
        this.referencedBeans.remove(descriptor.getReferencedBeanName());
    }

    public void addRenderKit(RenderKitBean descriptor) {
        DigesterFactory.VersionListener listener;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "addRenderKit(" + descriptor.getRenderKitId() + ")");
        }
        if (null != (listener = DigesterFactory.getVersionListener())) {
            listener.takeActionOnArtifact(descriptor.getRenderKitId());
        }
        this.renderKits.put(descriptor.getRenderKitId(), descriptor);
    }

    public RenderKitBean getRenderKit(String id) {
        return this.renderKits.get(id);
    }

    public RenderKitBean[] getRenderKits() {
        RenderKitBean[] results = new RenderKitBean[this.renderKits.size()];
        return this.renderKits.values().toArray(results);
    }

    public void removeRenderKit(RenderKitBean descriptor) {
        this.renderKits.remove(descriptor.getRenderKitId());
    }

    public void addValidator(ValidatorBean descriptor) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "addValidator(" + descriptor.getValidatorId() + ")");
        }
        this.validators.put(descriptor.getValidatorId(), descriptor);
    }

    public ValidatorBean getValidator(String id) {
        return this.validators.get(id);
    }

    public ValidatorBean[] getValidators() {
        ValidatorBean[] results = new ValidatorBean[this.validators.size()];
        return this.validators.values().toArray(results);
    }

    public void removeValidator(ValidatorBean descriptor) {
        this.validators.remove(descriptor.getValidatorId());
    }
}

