/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.Coercions;
import com.sun.faces.el.impl.Constants;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.Expression;
import com.sun.faces.el.impl.ExpressionInfo;
import com.sun.faces.el.impl.FunctionMapper;
import com.sun.faces.el.impl.MessageUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FunctionInvocation
extends Expression {
    private static Log log = LogFactory.getLog((Class)(class$com$sun$faces$el$impl$FunctionInvocation == null ? (class$com$sun$faces$el$impl$FunctionInvocation = FunctionInvocation.class$("com.sun.faces.el.impl.FunctionInvocation")) : class$com$sun$faces$el$impl$FunctionInvocation));
    private String functionName;
    private List argumentList;
    static /* synthetic */ Class class$com$sun$faces$el$impl$FunctionInvocation;

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String f) {
        this.functionName = f;
    }

    public List getArgumentList() {
        return this.argumentList;
    }

    public void setArgumentList(List l) {
        this.argumentList = l;
    }

    public FunctionInvocation(String functionName, List argumentList) {
        this.functionName = functionName;
        this.argumentList = argumentList;
    }

    public String getExpressionString() {
        StringBuffer b = new StringBuffer();
        b.append(this.functionName);
        b.append("(");
        Iterator i = this.argumentList.iterator();
        while (i.hasNext()) {
            b.append(((Expression)i.next()).getExpressionString());
            if (!i.hasNext()) continue;
            b.append(", ");
        }
        b.append(")");
        return b.toString();
    }

    public Object evaluate(ExpressionInfo exprInfo) throws ElException {
        FunctionMapper functions = exprInfo.getFunctionMapper();
        if (functions == null && log.isErrorEnabled()) {
            String message = MessageUtil.getMessageWithArgs(Constants.UNKNOWN_FUNCTION, this.functionName);
            log.error((Object)message);
            throw new ElException(message);
        }
        String prefix = null;
        String localName = null;
        int index = this.functionName.indexOf(58);
        if (index == -1) {
            prefix = "";
            localName = this.functionName;
        } else {
            prefix = this.functionName.substring(0, index);
            localName = this.functionName.substring(index + 1);
        }
        Method target = functions.resolve(prefix, localName);
        if (target == null && log.isErrorEnabled()) {
            String message = MessageUtil.getMessageWithArgs(Constants.UNKNOWN_FUNCTION, this.functionName);
            log.error((Object)message);
            throw new ElException(message);
        }
        Class<?>[] params = target.getParameterTypes();
        if (params.length != this.argumentList.size() && log.isErrorEnabled()) {
            String message = MessageUtil.getMessageWithArgs(Constants.INAPPROPRIATE_FUNCTION_ARG_COUNT, this.functionName, new Integer(params.length), new Integer(this.argumentList.size()));
            log.error((Object)message);
            throw new ElException(message);
        }
        Object[] arguments = new Object[this.argumentList.size()];
        for (int i = 0; i < params.length; ++i) {
            arguments[i] = ((Expression)this.argumentList.get(i)).evaluate(exprInfo);
            arguments[i] = Coercions.coerce(arguments[i], params[i]);
        }
        try {
            return target.invoke(null, arguments);
        }
        catch (InvocationTargetException ex) {
            if (log.isErrorEnabled()) {
                String message = MessageUtil.getMessageWithArgs(Constants.FUNCTION_INVOCATION_ERROR, this.functionName);
                Throwable t = ex.getTargetException();
                log.error((Object)message, t);
                throw new ElException(message, t);
            }
            return null;
        }
        catch (Throwable t) {
            if (log.isErrorEnabled()) {
                String message = MessageUtil.getMessageWithArgs(Constants.FUNCTION_INVOCATION_ERROR, this.functionName);
                log.error((Object)message, t);
                throw new ElException(message, t);
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

