/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.inject.spi;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDIProvider;

public abstract class CDI<T>
implements Instance<T>,
AutoCloseable {
    protected static volatile Set<CDIProvider> discoveredProviders = null;
    protected static volatile CDIProvider configuredProvider = null;
    private static final Object lock = new Object();

    public static CDI<Object> current() {
        return CDI.getCDIProvider().getCDI();
    }

    public static void setCDIProvider(CDIProvider provider) {
        if (provider == null) {
            throw new IllegalStateException("CDIProvider must not be null");
        }
        configuredProvider = provider;
    }

    public abstract void shutdown();

    @Override
    public void close() {
        this.shutdown();
    }

    public abstract BeanManager getBeanManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CDIProvider getCDIProvider() {
        if (configuredProvider != null) {
            return configuredProvider;
        }
        if (discoveredProviders == null) {
            Object object = lock;
            synchronized (object) {
                if (discoveredProviders == null) {
                    CDI.findAllProviders();
                }
            }
        }
        configuredProvider = discoveredProviders.stream().filter(c -> c.getCDI() != null).findAny().orElseThrow(() -> new IllegalStateException("Unable to access CDI"));
        return configuredProvider;
    }

    private static void findAllProviders() {
        LinkedHashSet providers = new LinkedHashSet();
        ServiceLoader<CDIProvider> providerLoader = ServiceLoader.load(CDIProvider.class, CDI.class.getClassLoader());
        if (!providerLoader.iterator().hasNext()) {
            throw new IllegalStateException("Unable to locate CDIProvider");
        }
        try {
            providerLoader.forEach(providers::add);
        }
        catch (ServiceConfigurationError e) {
            throw new IllegalStateException(e);
        }
        discoveredProviders = Collections.unmodifiableSet(providers);
    }
}

