/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.annotation.impl;

import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.annotation.CacheMethodDetails;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.impl.DefaultCacheResolver;

public class DefaultCacheResolverFactory
implements CacheResolverFactory {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final CacheManager cacheManager;

    public DefaultCacheResolverFactory(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public DefaultCacheResolverFactory() {
        this.cacheManager = Caching.getCacheManager();
    }

    public CacheResolver getCacheResolver(CacheMethodDetails<? extends Annotation> cacheMethodDetails) {
        String cacheName = cacheMethodDetails.getCacheName();
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            this.logger.warning("No Cache named '" + cacheName + "' was found in the CacheManager, a copy of the default cache will be created.");
            CacheBuilder cacheBuilder = this.cacheManager.createCacheBuilder(cacheName);
            cache = cacheBuilder.build();
        }
        return new DefaultCacheResolver((Cache<Object, Object>)cache);
    }

    public CacheResolver getExceptionCacheResolver(CacheMethodDetails<CacheResult> cacheMethodDetails) {
        CacheResult cacheResultAnnotation = (CacheResult)cacheMethodDetails.getCacheAnnotation();
        String exceptionCacheName = cacheResultAnnotation.exceptionCacheName();
        if (exceptionCacheName == null || exceptionCacheName.trim().length() == 0) {
            throw new IllegalArgumentException("Can only be called when CacheResult.exceptionCacheName() is specified");
        }
        Cache cache = this.cacheManager.getCache(exceptionCacheName);
        if (cache == null) {
            this.logger.warning("No Cache named '" + exceptionCacheName + "' was found in the CacheManager, a copy of the default cache will be created.");
            CacheBuilder cacheBuilder = this.cacheManager.createCacheBuilder(exceptionCacheName);
            cache = cacheBuilder.build();
        }
        return new DefaultCacheResolver((Cache<Object, Object>)cache);
    }
}

