/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.annotation.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import javax.cache.annotation.CacheInvocationParameter;
import javax.cache.annotation.impl.AbstractInternalCacheInvocationContext;
import javax.cache.annotation.impl.CacheParameterDetails;
import javax.cache.annotation.impl.CachePutMethodDetails;
import javax.cache.annotation.impl.InterceptorType;
import javax.cache.annotation.impl.InternalCacheKeyInvocationContext;
import javax.cache.annotation.impl.StaticCacheKeyInvocationContext;

public abstract class AbstractInternalCacheKeyInvocationContext<I, A extends Annotation>
extends AbstractInternalCacheInvocationContext<I, A>
implements InternalCacheKeyInvocationContext<A> {
    private final StaticCacheKeyInvocationContext<A> staticCacheKeyInvocationContext;
    private final CacheInvocationParameter[] keyParameters;
    private final CacheInvocationParameter valueParameter;

    public AbstractInternalCacheKeyInvocationContext(StaticCacheKeyInvocationContext<A> staticCacheKeyInvocationContext, I invocation) {
        super(staticCacheKeyInvocationContext, invocation);
        int parameterPosition;
        this.staticCacheKeyInvocationContext = staticCacheKeyInvocationContext;
        CacheInvocationParameter[] allParameters = this.getAllParameters();
        List<CacheParameterDetails> keyParameterDetails = staticCacheKeyInvocationContext.getKeyParameters();
        this.keyParameters = new CacheInvocationParameter[keyParameterDetails.size()];
        int pIdx = 0;
        for (CacheParameterDetails parameterDetails : keyParameterDetails) {
            parameterPosition = parameterDetails.getParameterPosition();
            this.keyParameters[pIdx++] = allParameters[parameterPosition];
        }
        if (staticCacheKeyInvocationContext.getInterceptorType() == InterceptorType.CACHE_PUT) {
            CachePutMethodDetails cachePutMethodDetails = (CachePutMethodDetails)staticCacheKeyInvocationContext;
            CacheParameterDetails cacheValueParameter = cachePutMethodDetails.getCacheValueParameter();
            parameterPosition = cacheValueParameter.getParameterPosition();
            this.valueParameter = allParameters[parameterPosition];
        } else {
            this.valueParameter = null;
        }
    }

    @Override
    public StaticCacheKeyInvocationContext<A> getStaticCacheKeyInvocationContext() {
        return this.staticCacheKeyInvocationContext;
    }

    @Override
    protected Object[] getParameters(I invocation) {
        return null;
    }

    @Override
    protected Method getMethod(I invocation) {
        return null;
    }

    @Override
    protected Object getTarget(I invocation) {
        return null;
    }

    public CacheInvocationParameter[] getKeyParameters() {
        return (CacheInvocationParameter[])this.keyParameters.clone();
    }

    public CacheInvocationParameter getValueParameter() {
        return this.valueParameter;
    }
}

