/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.annotation.impl;

import java.lang.annotation.Annotation;
import javax.cache.Cache;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheRemoveEntry;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.impl.AbstractKeyedCacheInterceptor;
import javax.cache.annotation.impl.CacheContextSource;
import javax.cache.annotation.impl.CacheRemoveEntryMethodDetails;
import javax.cache.annotation.impl.ClassFilter;
import javax.cache.annotation.impl.InterceptorType;
import javax.cache.annotation.impl.InternalCacheKeyInvocationContext;

public abstract class AbstractCacheRemoveEntryInterceptor<I>
extends AbstractKeyedCacheInterceptor<I, CacheRemoveEntryMethodDetails> {
    public final Object cacheRemoveEntry(CacheContextSource<I> cacheContextSource, I invocation) throws Throwable {
        Object result;
        InternalCacheKeyInvocationContext<Annotation> cacheKeyInvocationContext = cacheContextSource.getCacheKeyInvocationContext(invocation);
        CacheRemoveEntryMethodDetails methodDetails = (CacheRemoveEntryMethodDetails)this.getStaticCacheKeyInvocationContext(cacheKeyInvocationContext, InterceptorType.CACHE_REMOVE_ENTRY);
        CacheRemoveEntry cacheRemoveEntryAnnotation = (CacheRemoveEntry)methodDetails.getCacheAnnotation();
        boolean afterInvocation = cacheRemoveEntryAnnotation.afterInvocation();
        if (!afterInvocation) {
            this.cacheRemove(cacheKeyInvocationContext, methodDetails);
        }
        try {
            result = this.proceed(invocation);
        }
        catch (Throwable t) {
            Class[] noEvictFor;
            Class[] evictFor;
            boolean cache;
            if (afterInvocation && (cache = ClassFilter.isIncluded(t, evictFor = cacheRemoveEntryAnnotation.evictFor(), noEvictFor = cacheRemoveEntryAnnotation.noEvictFor(), false))) {
                this.cacheRemove(cacheKeyInvocationContext, methodDetails);
            }
            throw t;
        }
        if (afterInvocation) {
            this.cacheRemove(cacheKeyInvocationContext, methodDetails);
        }
        return result;
    }

    private void cacheRemove(InternalCacheKeyInvocationContext<? extends Annotation> cacheKeyInvocationContext, CacheRemoveEntryMethodDetails methodDetails) {
        CacheResolver cacheResolver = methodDetails.getCacheResolver();
        Cache cache = cacheResolver.resolveCache(cacheKeyInvocationContext);
        CacheKeyGenerator cacheKeyGenerator = methodDetails.getCacheKeyGenerator();
        CacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        cache.remove((Object)cacheKey);
    }
}

