/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.integration;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.cache.integration.CacheLoader;
import org.jsr107.tck.support.CacheClient;
import org.jsr107.tck.support.Operation;

public class CacheLoaderClient<K, V>
extends CacheClient
implements CacheLoader<K, V> {
    public CacheLoaderClient(InetAddress address, int port) {
        super(address, port);
        this.client = null;
    }

    public V load(K key) {
        return (V)this.getClient().invoke(new LoadOperation(key));
    }

    public Map<K, V> loadAll(Iterable<? extends K> keys) {
        return (Map)this.getClient().invoke(new LoadAllOperation(keys));
    }

    private static class LoadAllOperation<K, V>
    implements Operation<Map<K, V>> {
        private Iterable<? extends K> keys;

        public LoadAllOperation(Iterable<? extends K> keys) {
            this.keys = keys;
        }

        @Override
        public String getType() {
            return "loadAll";
        }

        @Override
        public Map<K, V> onInvoke(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException, ExecutionException {
            for (K key : this.keys) {
                oos.writeObject(key);
            }
            oos.writeObject(null);
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            Object result = ois.readObject();
            while (result != null && !(result instanceof Exception)) {
                Object key = result;
                Object value = ois.readObject();
                map.put(key, value);
                result = ois.readObject();
            }
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            return map;
        }
    }

    private static class LoadOperation<K, V>
    implements Operation<V> {
        private K key;

        public LoadOperation(K key) {
            this.key = key;
        }

        @Override
        public String getType() {
            return "load";
        }

        @Override
        public V onInvoke(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            oos.writeObject(this.key);
            Object o = ois.readObject();
            if (o instanceof RuntimeException) {
                throw (RuntimeException)o;
            }
            return (V)o;
        }
    }
}

