/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.test;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class XorShift {
    public static final int BITS = 4096;
    public static final BigInteger twoToBitsMinus1;
    public static final BigInteger[] factor;
    public static final BigInteger[] cofactor;
    public static final int numCofactors;
    public static long[][] right;
    public static long[][] left;

    private XorShift() {
    }

    public static long[][] newMatrix(int bits) {
        int i;
        long[][] result = new long[bits][];
        for (i = 0; i < 64; ++i) {
            result[i] = new long[bits / 64];
            result[i + (bits - 64)] = new long[bits / 64];
        }
        for (i = 64; i < bits - 64; ++i) {
            result[i] = new long[1];
        }
        return result;
    }

    public static long word(long[][] matrix, int r, int cw, int bits) {
        if (r < 64 || r >= bits - 64) {
            return matrix[r][cw];
        }
        if (r - cw * 64 >= 0) {
            return matrix[r - cw * 64][0];
        }
        return matrix[r % 64][cw - r / 64];
    }

    public static long[] multiply(long[] x, long[] y) {
        long[] u = new long[64];
        int i = 64;
        while (i-- != 0) {
            long rx = x[i];
            long ra = 0L;
            int j = 64;
            while (j-- != 0) {
                if ((rx & 1L << j) == 0L) continue;
                ra ^= y[j];
            }
            u[i] = ra;
        }
        return u;
    }

    public static long[][] multiply(long[][] x, long[][] y) {
        int w;
        int b;
        int offset;
        long t;
        long[] xr;
        int r;
        long[][] z = XorShift.newMatrix(4096);
        for (r = 0; r < 64; ++r) {
            xr = x[r];
            long[] zr = z[r];
            int cw = 64;
            while (cw-- != 0) {
                t = xr[cw];
                offset = cw * 64 + 63;
                b = 64;
                while (b-- != 0) {
                    if ((t & 1L) != 0L) {
                        w = 64;
                        while (w-- != 0) {
                            int n = w;
                            zr[n] = zr[n] ^ XorShift.word(y, offset - b, w, 4096);
                        }
                    }
                    t >>>= 1;
                }
            }
        }
        while (r < 4032) {
            long[] zr = z[r];
            int cw = 64;
            while (cw-- != 0) {
                long t2 = XorShift.word(x, r, cw, 4096);
                int offset2 = cw * 64 + 63;
                int b2 = 64;
                while (b2-- != 0) {
                    if ((t2 & 1L) != 0L) {
                        zr[0] = zr[0] ^ y[offset2 - b2][0];
                    }
                    t2 >>>= 1;
                }
            }
            ++r;
        }
        while (r < 4096) {
            xr = x[r];
            long[] zr = z[r];
            int cw = 64;
            while (cw-- != 0) {
                t = xr[cw];
                offset = cw * 64 + 63;
                b = 64;
                while (b-- != 0) {
                    if ((t & 1L) != 0L) {
                        w = 64;
                        while (w-- != 0) {
                            int n = w;
                            zr[n] = zr[n] ^ XorShift.word(y, offset - b, w, 4096);
                        }
                    }
                    t >>>= 1;
                }
            }
            ++r;
        }
        return z;
    }

    public static long[][][] quad(long[][] x) {
        long[][][] result = new long[4097][][];
        result[0] = x;
        for (int i = 1; i <= 4096; ++i) {
            result[i] = XorShift.multiply(result[i - 1], result[i - 1]);
        }
        return result;
    }

    public static long[][] identity() {
        long[][] m = XorShift.newMatrix(4096);
        int i = 64;
        while (i-- != 0) {
            m[i][0] = 1L << i;
        }
        i = 64;
        while (i-- != 0) {
            m[4032 + i][63] = 1L << i;
        }
        return m;
    }

    public static boolean isIdentity(long[][] m) {
        int r;
        int cw;
        int r2 = 64;
        while (r2-- != 0) {
            if (m[r2][0] == 1L << r2) continue;
            return false;
        }
        for (cw = 1; cw < 64; ++cw) {
            r = 64;
            while (r-- != 0) {
                if (m[r][cw] == 0L) continue;
                return false;
            }
        }
        for (r2 = 64; r2 < 4032; ++r2) {
            if (m[r2][0] == 0L) continue;
            return false;
        }
        r2 = 64;
        while (r2-- != 0) {
            if (m[4032 + r2][63] == 1L << r2) continue;
            return false;
        }
        for (cw = 0; cw < 63; ++cw) {
            r = 64;
            while (r-- != 0) {
                if (m[4032 + r][cw] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public static long[][] mPow(long[][][] q, BigInteger e) {
        long[][] r = XorShift.identity();
        int i = 0;
        while (!e.equals(BigInteger.ZERO)) {
            if (e.testBit(0)) {
                r = XorShift.multiply(r, q[i]);
            }
            e = e.shiftRight(1);
            ++i;
        }
        return r;
    }

    public static boolean isFull(long[][] m) {
        long[][][] q = XorShift.quad(m);
        if (!Arrays.deepEquals((Object[])m, (Object[])q[4096])) {
            System.err.println("Does not give the identity");
            return false;
        }
        for (int i = 0; i < numCofactors; ++i) {
            if (!XorShift.isIdentity(XorShift.mPow(q, cofactor[i]))) continue;
            System.err.println("Gives the identity on cofactor " + cofactor[i]);
            return false;
        }
        return true;
    }

    public static long[][] makeABCMatrix(int a, int b, int c, int bits) {
        long[][] m = XorShift.newMatrix(bits);
        long[] top = XorShift.multiply(left[a], right[b]);
        int i = 64;
        while (i-- != 0) {
            m[i][bits / 64 - 1] = top[i];
        }
        i = 64;
        while (i-- != 0) {
            m[bits - 64 + i][bits / 64 - 1] = right[c][i];
        }
        i = 64;
        while (i-- != 0) {
            m[bits - 64 + i][bits / 64 - 2] = 1L << i;
        }
        i = 64;
        while (i-- != 0) {
            m[64 + i][0] = 1L << i;
        }
        return m;
    }

    public static void main(String[] arg) {
        if (arg.length > 0) {
            throw new IllegalArgumentException("This command takes no arguments (BITS=4096)");
        }
        ExecutorService exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (int a = 1; a < 64; ++a) {
            for (int b = 1; b <= 64 - a; ++b) {
                if (BigInteger.valueOf(a).gcd(BigInteger.valueOf(b)).intValue() != 1) continue;
                for (int c = 1; c < 64; ++c) {
                    exec.execute(new Compute(a, b, c));
                }
            }
        }
        exec.shutdown();
    }

    static {
        int i;
        int i2;
        twoToBitsMinus1 = BigInteger.valueOf(2L).pow(4096).subtract(BigInteger.ONE);
        factor = new BigInteger[]{new BigInteger("3"), new BigInteger("5"), new BigInteger("17"), new BigInteger("257"), new BigInteger("65537"), new BigInteger("641"), new BigInteger("6700417"), new BigInteger("274177"), new BigInteger("67280421310721"), new BigInteger("59649589127497217"), new BigInteger("5704689200685129054721"), new BigInteger("1238926361552897"), new BigInteger("93461639715357977769163558199606896584051237541638188580280321"), new BigInteger("2424833"), new BigInteger("7455602825647884208337395736200454918783366342657"), new BigInteger("741640062627530801524787141901937474059940781097519023905821316144415759504705008092818711693940737"), new BigInteger("45592577"), new BigInteger("6487031809"), new BigInteger("4659775785220018543264560743076778192897"), new BigInteger("130439874405488189727484768796509903946608530841611892186895295776832416251471863574140227977573104895898783928842923844831149032913798729088601617946094119449010595906710130531906171018354491609619193912488538116080712299672322806217820753127014424577"), new BigInteger("319489"), new BigInteger("974849"), new BigInteger("167988556341760475137"), new BigInteger("3560841906445833920513"), new BigInteger("173462447179147555430258970864309778377421844723664084649347019061363579192879108857591038330408837177983810868451546421940712978306134189864280826014542758708589243873685563973118948869399158545506611147420216132557017260564139394366945793220968665108959685482705388072645828554151936401912464931182546092879815733057795573358504982279280090942872567591518912118622751714319229788100979251036035496917279912663527358783236647193154777091427745377038294584918917590325110939381322486044298573971650711059244462177542540706913047034664643603491382441723306598834177")};
        cofactor = new BigInteger[factor.length];
        BigInteger result = BigInteger.ONE;
        for (i2 = 0; i2 < factor.length; ++i2) {
            XorShift.cofactor[i2] = twoToBitsMinus1.divide(factor[i2]);
            if (twoToBitsMinus1.equals(result = result.multiply(factor[i2]))) break;
        }
        numCofactors = i2 + 1;
        if (!twoToBitsMinus1.equals(result)) {
            throw new AssertionError();
        }
        right = new long[64][64];
        left = new long[64][64];
        for (i = 0; i < 63; ++i) {
            long[] lArray = right[1];
            int n = i + 1;
            lArray[n] = lArray[n] | 1L << i;
        }
        for (i = 0; i < 63; ++i) {
            long[] lArray = left[1];
            int n = i;
            lArray[n] = lArray[n] | 1L << i + 1;
        }
        for (i = 2; i < 64; ++i) {
            XorShift.left[i] = XorShift.multiply(left[i - 1], left[1]);
            XorShift.right[i] = XorShift.multiply(right[i - 1], right[1]);
        }
        i = 64;
        while (i-- != 0) {
            int j = 64;
            while (j-- != 0) {
                long[] lArray = right[i];
                int n = j;
                lArray[n] = lArray[n] | 1L << j;
                long[] lArray2 = left[i];
                int n2 = j;
                lArray2[n2] = lArray2[n2] | 1L << j;
            }
        }
    }

    public static final class Compute
    implements Runnable {
        final int a;
        final int b;
        final int c;

        public Compute(int a, int b, int c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        @Override
        public void run() {
            long[][] m = XorShift.makeABCMatrix(this.a, this.b, this.c, 4096);
            System.out.println(this.a + " " + this.b + " " + this.c + " " + XorShift.isFull(m));
        }
    }
}

