/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.HashCommon;
import org.apache.commons.math3.random.AbstractRandomGenerator;

public class SplitMix64RandomGenerator
extends AbstractRandomGenerator {
    private static final long PHI = -7046029254386353131L;
    private long x;

    public SplitMix64RandomGenerator() {
        this(Util.randomSeed());
    }

    public SplitMix64RandomGenerator(long seed) {
        this.setSeed(seed);
    }

    private static long staffordMix13(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    private static int staffordMix4Upper32(long z) {
        z = (z ^ z >>> 33) * 7109453100751455733L;
        return (int)((z ^ z >>> 28) * -3808689974395783757L >>> 32);
    }

    public long nextLong() {
        return SplitMix64RandomGenerator.staffordMix13(this.x += -7046029254386353131L);
    }

    public int nextInt() {
        return SplitMix64RandomGenerator.staffordMix4Upper32(this.x += -7046029254386353131L);
    }

    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return (int)((SplitMix64RandomGenerator.staffordMix13(this.x += -7046029254386353131L) >>> 1) % (long)n);
    }

    public long nextLong(long n) {
        long value;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException();
        }
        while ((bits = SplitMix64RandomGenerator.staffordMix13(this.x += -7046029254386353131L) >>> 1) - (value = bits % n) + (n - 1L) < 0L) {
        }
        return value;
    }

    public double nextDouble() {
        return Double.longBitsToDouble(SplitMix64RandomGenerator.staffordMix13(this.x += -7046029254386353131L) >>> 12 | 0x3FF0000000000000L) - 1.0;
    }

    public float nextFloat() {
        return Float.intBitsToFloat(SplitMix64RandomGenerator.staffordMix4Upper32(this.x += -7046029254386353131L) >>> 41 | 0x3F800000) - 1.0f;
    }

    public boolean nextBoolean() {
        return SplitMix64RandomGenerator.staffordMix4Upper32(this.x += -7046029254386353131L) < 0;
    }

    public void nextBytes(byte[] bytes) {
        int i = bytes.length;
        int n = 0;
        while (i != 0) {
            n = Math.min(i, 8);
            long bits = SplitMix64RandomGenerator.staffordMix13(this.x += -7046029254386353131L);
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }

    public void setSeed(long seed) {
        this.x = HashCommon.murmurHash3((long)seed);
    }

    public void setState(long state) {
        this.x = state;
    }
}

