/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.HashCommon;
import org.apache.commons.math3.random.AbstractRandomGenerator;

public class XorShift128PlusRandomGenerator
extends AbstractRandomGenerator {
    private static final double NORM_53 = (double)1.110223E-16f;
    private static final double NORM_24 = 5.960464477539063E-8;
    private long s0;
    private long s1;

    public XorShift128PlusRandomGenerator() {
        this(Util.randomSeed());
    }

    public XorShift128PlusRandomGenerator(long seed) {
        this.setSeed(seed);
    }

    public long nextLong() {
        long s0;
        long s1 = this.s0;
        this.s0 = s0 = this.s1;
        s1 ^= s1 << 23;
        this.s1 = s1 ^ s0 ^ s1 >>> 17 ^ s0 >>> 26;
        return this.s1 + s0;
    }

    public int nextInt() {
        return (int)this.nextLong();
    }

    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    public long nextLong(long n) {
        long value;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException();
        }
        while ((bits = this.nextLong() >>> 1) - (value = bits % n) + (n - 1L) < 0L) {
        }
        return value;
    }

    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    public float nextFloat() {
        return (float)((double)(this.nextLong() >>> 40) * 5.960464477539063E-8);
    }

    public boolean nextBoolean() {
        return this.nextLong() < 0L;
    }

    public void nextBytes(byte[] bytes) {
        int i = bytes.length;
        int n = 0;
        while (i != 0) {
            n = Math.min(i, 8);
            long bits = this.nextLong();
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }

    public void setSeed(long seed) {
        this.s0 = HashCommon.murmurHash3((long)(seed == 0L ? Long.MIN_VALUE : seed));
        this.s1 = HashCommon.murmurHash3((long)this.s0);
    }

    public void setState(long[] state) {
        if (state.length != 2) {
            throw new IllegalArgumentException("The argument array contains " + state.length + " longs instead of " + 2);
        }
        this.s0 = state[0];
        this.s1 = state[1];
    }
}

