/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.Util;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigList;
import java.io.Serializable;

public class HyperLogLogCounterArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean ASSERTS = false;
    private static final boolean DEBUG = false;
    public static final int CHUNK_SHIFT = 30;
    public static final long CHUNK_SIZE = 0x40000000L;
    public static final long CHUNK_MASK = 0x3FFFFFFFL;
    private double alphaMM;
    protected final int mMinus1;
    protected final long[][] bits;
    protected final LongBigList[] registers;
    protected final int counterShift;
    protected long seed;
    private long sentinelMask;
    protected final boolean longwordAligned;
    protected final long counterResidualMask;
    protected final long[] msbMask;
    protected final long[] lsbMask;
    public final int log2m;
    public final int m;
    public final int registerSize;
    public final int counterSize;
    public final int counterLongwords;

    public static int log2NumberOfRegisters(double rsd) {
        return (int)Math.ceil(Fast.log2(1.106 / rsd * (1.106 / rsd)));
    }

    public static double relativeStandardDeviation(int log2m) {
        return (log2m == 4 ? 1.106 : (log2m == 5 ? 1.07 : (log2m == 6 ? 1.054 : (log2m == 7 ? 1.046 : 1.04)))) / Math.sqrt(1 << log2m);
    }

    public static int registerSize(long n) {
        return Math.max(5, (int)Math.ceil(Math.log(Math.log(n) / Math.log(2.0)) / Math.log(2.0)));
    }

    public int chunk(long counter) {
        return (int)(counter >>> this.counterShift);
    }

    public long offset(long counter) {
        return (counter << this.log2m & 0x3FFFFFFFL) * (long)this.registerSize;
    }

    public HyperLogLogCounterArray(long arraySize, long n, double rsd) {
        this(arraySize, n, HyperLogLogCounterArray.log2NumberOfRegisters(rsd));
    }

    public HyperLogLogCounterArray(long arraySize, long n, int log2m) {
        this(arraySize, n, log2m, Util.randomSeed());
    }

    public HyperLogLogCounterArray(long arraySize, long n, int log2m, long seed) {
        int i;
        if (log2m > 30) {
            throw new IllegalArgumentException("The logarithm of the number of register per counter (" + log2m + ") is too large");
        }
        this.log2m = log2m;
        this.m = 1 << this.log2m;
        this.mMinus1 = this.m - 1;
        this.registerSize = HyperLogLogCounterArray.registerSize(n);
        this.counterSize = this.registerSize << log2m;
        this.counterShift = 30 - log2m;
        this.sentinelMask = 1L << (1 << this.registerSize) - 2;
        long sizeInRegisters = arraySize * (long)this.m;
        int numVectors = (int)(sizeInRegisters + 0x3FFFFFFFL >>> 30);
        this.bits = new long[numVectors][];
        this.registers = new LongBigList[numVectors];
        for (i = 0; i < numVectors; ++i) {
            LongArrayBitVector bitVector = LongArrayBitVector.ofLength((long)this.registerSize * Math.min(0x40000000L, sizeInRegisters - ((long)i << 30)));
            this.bits[i] = bitVector.bits();
            this.registers[i] = bitVector.asLongBigList(this.registerSize);
        }
        this.counterLongwords = (this.counterSize + 64 - 1) / 64;
        this.counterResidualMask = (1L << this.counterSize % 64) - 1L;
        this.longwordAligned = this.counterSize % 64 == 0;
        this.msbMask = new long[this.counterLongwords];
        this.lsbMask = new long[this.counterLongwords];
        for (i = this.registerSize - 1; i < this.msbMask.length * 64; i += this.registerSize) {
            int n2 = i / 64;
            this.msbMask[n2] = this.msbMask[n2] | 1L << i % 64;
        }
        for (i = 0; i < this.lsbMask.length * 64; i += this.registerSize) {
            int n3 = i / 64;
            this.lsbMask[n3] = this.lsbMask[n3] | 1L << i % 64;
        }
        this.seed = seed;
        switch (log2m) {
            case 4: {
                this.alphaMM = 0.673 * (double)this.m * (double)this.m;
                break;
            }
            case 5: {
                this.alphaMM = 0.697 * (double)this.m * (double)this.m;
                break;
            }
            case 6: {
                this.alphaMM = 0.709 * (double)this.m * (double)this.m;
                break;
            }
            default: {
                this.alphaMM = 0.7213 / (1.0 + 1.079 / (double)this.m) * (double)this.m * (double)this.m;
            }
        }
    }

    public void clear(long seed) {
        this.clear();
        this.seed = seed;
    }

    public void clear() {
        for (long[] a : this.bits) {
            LongArrays.fill((long[])a, (long)0L);
        }
    }

    private static final long jenkins(long x, long seed) {
        long a = seed + x;
        long b = seed;
        long c = -7046029254386353133L;
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >>> 43);
        c -= a;
        c -= (b ^= a << 9);
        a -= b;
        a -= (c ^= b >>> 8);
        b -= c;
        b -= (a ^= c >>> 38);
        c -= a;
        c -= (b ^= a << 23);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 35);
        c -= a;
        c -= (b ^= a << 49);
        a -= b;
        a -= (c ^= b >>> 11);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 18);
        return c ^= b >>> 22;
    }

    public void add(long k, long v) {
        long x = HyperLogLogCounterArray.jenkins(v, this.seed);
        int j = (int)(x & (long)this.mMinus1);
        int r = Long.numberOfTrailingZeros(x >>> this.log2m | this.sentinelMask);
        LongBigList l = this.registers[this.chunk(k)];
        long offset = (k << this.log2m) + (long)j & 0x3FFFFFFFL;
        l.set(offset, Math.max((long)(r + 1), l.getLong(offset)));
    }

    public LongBigList[] registers() {
        return this.registers;
    }

    public double count(long[] bits, long offset) {
        int remaining = (int)(64L - offset % 64L);
        int word = (int)(offset / 64L);
        long curr = bits[word] >>> (int)(offset % 64L);
        int registerSize = this.registerSize;
        int mask = (1 << registerSize) - 1;
        double s = 0.0;
        int zeroes = 0;
        int j = this.m;
        while (j-- != 0) {
            long r;
            if (remaining >= registerSize) {
                r = curr & (long)mask;
                curr >>>= registerSize;
                remaining -= registerSize;
            } else {
                r = (curr | bits[++word] << remaining) & (long)mask;
                curr = bits[word] >>> registerSize - remaining;
                remaining += 64 - registerSize;
            }
            if (r == 0L) {
                ++zeroes;
            }
            s += 1.0 / (double)(1L << (int)r);
        }
        s = this.alphaMM / s;
        if (zeroes != 0 && s < 5.0 * (double)this.m / 2.0) {
            return (double)this.m * Math.log((double)this.m / (double)zeroes);
        }
        return s;
    }

    public double count(long k) {
        return this.count(this.bits[this.chunk(k)], this.offset(k));
    }

    protected final void setCounter(long[] source, long[] chunkBits, long index) {
        if (this.longwordAligned) {
            System.arraycopy(source, 0, chunkBits, (int)(this.offset(index) / 64L), this.counterLongwords);
        } else {
            long offset = this.offset(index);
            int longwordOffset = (int)(offset / 64L);
            int bitOffset = (int)(offset % 64L);
            int last = this.counterLongwords - 1;
            if (bitOffset == 0) {
                int i = last;
                while (i-- != 0) {
                    chunkBits[longwordOffset + i] = source[i];
                }
                int n = longwordOffset + last;
                chunkBits[n] = chunkBits[n] & (this.counterResidualMask ^ 0xFFFFFFFFFFFFFFFFL);
                int n2 = longwordOffset + last;
                chunkBits[n2] = chunkBits[n2] | source[last] & this.counterResidualMask;
            } else {
                int n = longwordOffset;
                chunkBits[n] = chunkBits[n] & (1L << bitOffset) - 1L;
                int n3 = longwordOffset;
                chunkBits[n3] = chunkBits[n3] | source[0] << bitOffset;
                for (int i = 1; i < last; ++i) {
                    chunkBits[longwordOffset + i] = source[i - 1] >>> 64 - bitOffset | source[i] << bitOffset;
                }
                int remaining = this.counterSize % 64 + bitOffset;
                long mask = -1L >>> 64 - Math.min(64, remaining);
                int n4 = longwordOffset + last;
                chunkBits[n4] = chunkBits[n4] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                int n5 = longwordOffset + last;
                chunkBits[n5] = chunkBits[n5] | mask & (source[last - 1] >>> 64 - bitOffset | source[last] << bitOffset);
                if (remaining > 64) {
                    long mask2 = (1L << remaining - 64) - 1L;
                    int n6 = longwordOffset + last + 1;
                    chunkBits[n6] = chunkBits[n6] & (mask2 ^ 0xFFFFFFFFFFFFFFFFL);
                    int n7 = longwordOffset + last + 1;
                    chunkBits[n7] = chunkBits[n7] | mask2 & source[last] >>> 64 - bitOffset;
                }
            }
        }
    }

    public void setCounter(long[] source, long index) {
        this.setCounter(source, this.bits[this.chunk(index)], index);
    }

    protected final void getCounter(long[] chunkBits, long index, long[] dest) {
        if (this.longwordAligned) {
            System.arraycopy(chunkBits, (int)(this.offset(index) / 64L), dest, 0, this.counterLongwords);
        } else {
            long offset = this.offset(index);
            int longwordOffset = (int)(offset / 64L);
            int bitOffset = (int)(offset % 64L);
            int last = this.counterLongwords - 1;
            if (bitOffset == 0) {
                int i = last;
                while (i-- != 0) {
                    dest[i] = chunkBits[longwordOffset + i];
                }
                dest[last] = chunkBits[longwordOffset + last] & this.counterResidualMask;
            } else {
                for (int i = 0; i < last; ++i) {
                    dest[i] = chunkBits[longwordOffset + i] >>> bitOffset | chunkBits[longwordOffset + i + 1] << 64 - bitOffset;
                }
                dest[last] = chunkBits[longwordOffset + last] >>> bitOffset & this.counterResidualMask;
            }
        }
    }

    public final void getCounter(long index, long[] dest) {
        this.getCounter(this.bits[this.chunk(index)], index, dest);
    }

    protected final void transfer(long[] source, long[] dest, long node) {
        if (this.longwordAligned) {
            int longwordOffset = (int)(this.offset(node) / 64L);
            System.arraycopy(source, longwordOffset, dest, longwordOffset, this.counterLongwords);
        } else {
            long offset = this.offset(node);
            int longwordOffset = (int)(offset / 64L);
            int bitOffset = (int)(offset % 64L);
            int last = this.counterLongwords - 1;
            if (bitOffset == 0) {
                int i = last;
                while (i-- != 0) {
                    dest[longwordOffset + i] = source[longwordOffset + i];
                }
                int n = longwordOffset + last;
                dest[n] = dest[n] & (this.counterResidualMask ^ 0xFFFFFFFFFFFFFFFFL);
                int n2 = longwordOffset + last;
                dest[n2] = dest[n2] | source[longwordOffset + last] & this.counterResidualMask;
            } else {
                long mask = -1L << bitOffset;
                int n = longwordOffset;
                dest[n] = dest[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                int n3 = longwordOffset;
                dest[n3] = dest[n3] | source[longwordOffset] & mask;
                for (int i = 1; i < last; ++i) {
                    dest[longwordOffset + i] = source[longwordOffset + i];
                }
                int remaining = (this.counterSize + bitOffset) % 64;
                if (remaining == 0) {
                    dest[longwordOffset + last] = source[longwordOffset + last];
                } else {
                    long mask2 = (1L << remaining) - 1L;
                    int n4 = longwordOffset + last;
                    dest[n4] = dest[n4] & (mask2 ^ 0xFFFFFFFFFFFFFFFFL);
                    int n5 = longwordOffset + last;
                    dest[n5] = dest[n5] | mask2 & source[longwordOffset + last];
                }
            }
        }
    }

    private static final void subtract(long[] x, long[] y, int l) {
        boolean borrow = false;
        for (int i = 0; i < l; ++i) {
            block4: {
                block3: {
                    if (!borrow) break block3;
                    int n = i;
                    long l2 = x[n];
                    x[n] = l2 - 1L;
                    if (l2 == 0L) break block4;
                }
                borrow = x[i] < y[i] ^ x[i] < 0L ^ y[i] < 0L;
            }
            int n = i;
            x[n] = x[n] - y[i];
        }
    }

    public final void max(long[] x, long[] y) {
        this.max(x, y, new long[x.length], new long[y.length]);
    }

    public final void max(long[] x, long[] y, long[] accumulator, long[] mask) {
        int l = x.length;
        long[] msbMask = this.msbMask;
        int i = l;
        while (i-- != 0) {
            accumulator[i] = y[i] | msbMask[i];
        }
        i = l;
        while (i-- != 0) {
            mask[i] = x[i] & (msbMask[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        HyperLogLogCounterArray.subtract(accumulator, mask, l);
        i = l;
        while (i-- != 0) {
            accumulator[i] = ((accumulator[i] | y[i] ^ x[i]) ^ (y[i] | x[i] ^ 0xFFFFFFFFFFFFFFFFL)) & msbMask[i];
        }
        int rMinus1 = this.registerSize - 1;
        int longSizeMinusRMinus1 = 64 - rMinus1;
        int i2 = l - 1;
        while (i2-- != 0) {
            mask[i2] = accumulator[i2] >>> rMinus1 | accumulator[i2 + 1] << longSizeMinusRMinus1 | msbMask[i2];
        }
        mask[l - 1] = accumulator[l - 1] >>> rMinus1 | msbMask[l - 1];
        HyperLogLogCounterArray.subtract(mask, this.lsbMask, l);
        i2 = l;
        while (i2-- != 0) {
            mask[i2] = (mask[i2] | msbMask[i2]) ^ accumulator[i2];
        }
        i2 = l;
        while (i2-- != 0) {
            int n = i2;
            x[n] = x[n] ^ (x[i2] ^ y[i2]) & mask[i2];
        }
    }
}

