/*
 * Decompiled with CFR 0.152.
 */
package ir.smartdevelopers.smartspinner;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.ColorUtils;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import ir.smartdevelopers.smartspinner.R;

public class SmartSpinnerBackgroundDrawable
extends Drawable {
    private Paint trianglePaint;
    private Paint linePaint;
    private Paint ripplePaint;
    private Path trianglePath;
    private float triangleWith;
    private float triangleHeight;
    private float triangleMarginHorizontal;
    private float lineStrokeWidth;
    private int paddingStart;
    private int paddingBottom;
    private int paddingTop;
    private float rippleRadius = 0.0f;
    private float rippleRadiusEdn;
    private int mPressedColor;
    private int mTint;
    private int mArrowColor;
    private int mLineColor;
    private int mDefaultColor = -16777216;
    private int mDirection = 0;
    private boolean mRoundArrow = false;
    private int mDeactivateColor = 0;
    private boolean mLastPressed = false;
    private boolean enabled = true;
    private boolean isAnimating = false;
    private boolean stopPressed = false;

    public SmartSpinnerBackgroundDrawable(Context context) {
        Resources resources = context.getResources();
        this.mArrowColor = this.mLineColor = this.mDefaultColor;
        int triangleDpWidth = 10;
        float arrowSize = TypedValue.applyDimension((int)1, (float)triangleDpWidth, (DisplayMetrics)resources.getDisplayMetrics());
        this.setArrowSize((int)arrowSize);
        float triangleStrokeWidth = TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)resources.getDisplayMetrics());
        int triangleMarginDpHorizontal = 16;
        this.triangleMarginHorizontal = TypedValue.applyDimension((int)1, (float)triangleMarginDpHorizontal, (DisplayMetrics)resources.getDisplayMetrics());
        this.lineStrokeWidth = TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)resources.getDisplayMetrics());
        this.rippleRadiusEdn = TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)resources.getDisplayMetrics());
        this.paddingStart = (int)(this.triangleWith + this.triangleMarginHorizontal * 2.0f);
        this.paddingTop = this.paddingBottom = (int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)resources.getDisplayMetrics());
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorControlActivated, typedValue, true);
        int defaultPressColor = typedValue.data;
        context.getTheme().resolveAttribute(R.attr.colorControlHighlight, typedValue, true);
        int rippleColor = typedValue.data;
        this.trianglePaint = new Paint(1);
        this.trianglePaint.setColor(this.mArrowColor);
        this.trianglePaint.setStrokeWidth(triangleStrokeWidth);
        this.trianglePaint.setStrokeJoin(Paint.Join.MITER);
        this.trianglePaint.setStrokeCap(Paint.Cap.SQUARE);
        this.trianglePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.trianglePath = new Path();
        this.linePaint = new Paint(1);
        this.linePaint.setStyle(Paint.Style.STROKE);
        this.linePaint.setStrokeWidth(this.lineStrokeWidth);
        this.linePaint.setColor(this.mLineColor);
        this.ripplePaint = new Paint(1);
        this.ripplePaint.setColor(rippleColor);
        this.mTint = this.mDefaultColor;
        this.mPressedColor = defaultPressColor;
    }

    public boolean isStateful() {
        return true;
    }

    @NonNull
    public int[] getState() {
        return super.getState();
    }

    public boolean setState(@NonNull int[] stateSet) {
        return super.setState(stateSet);
    }

    protected boolean onStateChange(int[] state) {
        if (!this.enabled) {
            int lineDeactivateColor = ColorUtils.setAlphaComponent((int)this.mLineColor, (int)38);
            int arrowDeactivateColor = ColorUtils.setAlphaComponent((int)this.mArrowColor, (int)38);
            if (this.mDeactivateColor != 0) {
                lineDeactivateColor = this.mDeactivateColor;
                arrowDeactivateColor = this.mDeactivateColor;
            }
            this.linePaint.setColor(lineDeactivateColor);
            this.trianglePaint.setColor(arrowDeactivateColor);
            return true;
        }
        boolean pressed = false;
        for (int s : state) {
            if (s != 16842919) continue;
            pressed = true;
            break;
        }
        if (pressed) {
            this.linePaint.setColor(this.mPressedColor);
            this.linePaint.setStrokeWidth(this.lineStrokeWidth * 3.0f);
            this.stopPressed = false;
            this.mLastPressed = true;
            this.animateRipplePress();
        } else if (this.mLastPressed) {
            this.mLastPressed = false;
            this.linePaint.setColor(this.mLineColor);
            this.linePaint.setStrokeWidth(this.lineStrokeWidth);
            this.stopPressed = true;
            if (!this.isAnimating) {
                this.hideRipple();
            }
        }
        return true;
    }

    private void hideRipple() {
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{67, 0});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int f = (Integer)animation.getAnimatedValue();
                SmartSpinnerBackgroundDrawable.this.ripplePaint.setAlpha(f);
                SmartSpinnerBackgroundDrawable.this.invalidateSelf();
            }
        });
        valueAnimator.setDuration(200L);
        valueAnimator.start();
    }

    private void animateRipplePress() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.rippleRadiusEdn});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float f = ((Float)animation.getAnimatedValue()).floatValue();
                int alpha = (int)(f * 127.0f / SmartSpinnerBackgroundDrawable.this.rippleRadiusEdn);
                if ((alpha = 127 - alpha) < 67) {
                    alpha = 67;
                }
                SmartSpinnerBackgroundDrawable.this.ripplePaint.setAlpha(alpha);
                SmartSpinnerBackgroundDrawable.this.rippleRadius = f;
                SmartSpinnerBackgroundDrawable.this.invalidateSelf();
            }
        });
        valueAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                SmartSpinnerBackgroundDrawable.this.isAnimating = true;
            }

            public void onAnimationEnd(Animator animation) {
                SmartSpinnerBackgroundDrawable.this.isAnimating = false;
                if (SmartSpinnerBackgroundDrawable.this.stopPressed) {
                    SmartSpinnerBackgroundDrawable.this.hideRipple();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        valueAnimator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        valueAnimator.setDuration(200L);
        valueAnimator.start();
    }

    public boolean getPadding(@NonNull Rect padding) {
        if (this.mDirection == 1) {
            padding.set(this.paddingStart, this.paddingTop, 0, this.paddingBottom);
        } else {
            padding.set(0, this.paddingTop, this.paddingStart, this.paddingBottom);
        }
        return true;
    }

    @Nullable
    public Drawable.ConstantState getConstantState() {
        return super.getConstantState();
    }

    public void draw(@NonNull Canvas canvas) {
        Rect rect = this.getBounds();
        Log.v((String)"TTT", (String)rect.toString());
        float cTriangleY = (float)rect.bottom / 2.0f;
        float cTriangleX = this.triangleWith / 2.0f + this.triangleMarginHorizontal;
        float startTriangleY = cTriangleY - this.triangleHeight / 2.0f;
        float startTriangleX = this.triangleMarginHorizontal;
        if (this.mDirection != 1) {
            startTriangleX = (float)rect.right - this.triangleMarginHorizontal - this.triangleWith;
        }
        float cx = startTriangleX + this.triangleWith / 2.0f;
        canvas.drawCircle(cx, cTriangleY, this.rippleRadius, this.ripplePaint);
        this.trianglePath.moveTo(startTriangleX, startTriangleY);
        this.trianglePath.rLineTo(this.triangleWith, 0.0f);
        this.trianglePath.rLineTo(-this.triangleWith / 2.0f, this.triangleHeight);
        this.trianglePath.lineTo(startTriangleX, startTriangleY);
        this.trianglePath.close();
        canvas.drawPath(this.trianglePath, this.trianglePaint);
        canvas.drawLine((float)rect.left, (float)rect.bottom - this.lineStrokeWidth, (float)rect.right, (float)rect.bottom - this.lineStrokeWidth, this.linePaint);
    }

    public void setAlpha(int alpha) {
        this.linePaint.setAlpha(alpha);
        this.trianglePaint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.linePaint.setColorFilter(colorFilter);
        this.trianglePaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public int getPressedColor() {
        return this.mPressedColor;
    }

    public void setPressedColor(int pressedColor) {
        this.mPressedColor = pressedColor;
    }

    public int getTint() {
        return this.mTint;
    }

    public void setTint(int tint) {
        this.mTint = tint;
        if (this.mTint != 0) {
            this.mArrowColor = this.mTint;
            this.mLineColor = this.mTint;
        } else {
            this.mArrowColor = this.mDefaultColor;
            this.mLineColor = this.mDefaultColor;
        }
        this.trianglePaint.setColor(this.mArrowColor);
        this.linePaint.setColor(this.mLineColor);
        this.invalidateSelf();
    }

    public int getArrowColor() {
        return this.mArrowColor;
    }

    public void setArrowColor(int arrowColor) {
        if (arrowColor == 0) {
            return;
        }
        this.mArrowColor = arrowColor;
        this.trianglePaint.setColor(this.mArrowColor);
        this.invalidateSelf();
    }

    public int getLineColor() {
        return this.mLineColor;
    }

    public void setLineColor(int lineColor) {
        if (lineColor == 0) {
            return;
        }
        this.mLineColor = lineColor;
        this.linePaint.setColor(this.mLineColor);
        this.invalidateSelf();
    }

    public void setArrowSize(int size) {
        this.triangleWith = size;
        this.triangleHeight = this.triangleWith / 2.0f;
        this.paddingStart = (int)(this.triangleWith + this.triangleMarginHorizontal * 2.0f);
        this.invalidateSelf();
    }

    public int getDirection() {
        return this.mDirection;
    }

    public void setDirection(int direction) {
        this.mDirection = direction;
        this.invalidateSelf();
    }

    public boolean isRoundArrow() {
        return this.mRoundArrow;
    }

    public void setRoundArrow(boolean roundArrow) {
        this.mRoundArrow = roundArrow;
        if (roundArrow) {
            this.trianglePaint.setStrokeCap(Paint.Cap.ROUND);
            this.trianglePaint.setStrokeJoin(Paint.Join.ROUND);
        } else {
            this.trianglePaint.setStrokeCap(Paint.Cap.SQUARE);
            this.trianglePaint.setStrokeJoin(Paint.Join.MITER);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getDeactivateColor() {
        return this.mDeactivateColor;
    }

    public void setDeactivateColor(int deactivateColor) {
        this.mDeactivateColor = deactivateColor;
    }
}

