/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres.junit5;

import io.zonky.test.db.postgres.embedded.EmbeddedPostgres;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class SingleInstancePostgresExtension
implements AfterTestExecutionCallback,
BeforeTestExecutionCallback {
    private volatile EmbeddedPostgres epg;
    private volatile Connection postgresConnection;
    private final List<Consumer<EmbeddedPostgres.Builder>> builderCustomizers = new CopyOnWriteArrayList<Consumer<EmbeddedPostgres.Builder>>();

    SingleInstancePostgresExtension() {
    }

    public void beforeTestExecution(ExtensionContext extensionContext) throws Exception {
        this.epg = this.pg();
        this.postgresConnection = this.epg.getPostgresDatabase().getConnection();
    }

    private EmbeddedPostgres pg() throws IOException {
        EmbeddedPostgres.Builder builder = EmbeddedPostgres.builder();
        this.builderCustomizers.forEach(c -> c.accept(builder));
        return builder.start();
    }

    public SingleInstancePostgresExtension customize(Consumer<EmbeddedPostgres.Builder> customizer) {
        if (this.epg != null) {
            throw new AssertionError((Object)"already started");
        }
        this.builderCustomizers.add(customizer);
        return this;
    }

    public EmbeddedPostgres getEmbeddedPostgres() {
        EmbeddedPostgres epg = this.epg;
        if (epg == null) {
            throw new AssertionError((Object)"JUnit test not started yet!");
        }
        return epg;
    }

    public void afterTestExecution(ExtensionContext extensionContext) {
        try {
            this.postgresConnection.close();
        }
        catch (SQLException e) {
            throw new AssertionError((Object)e);
        }
        try {
            this.epg.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

