/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres.embedded;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

final class ProcessOutputLogger
implements Runnable {
    private final Logger logger;
    private final BufferedReader reader;

    private ProcessOutputLogger(Logger logger, Process process) {
        this.logger = logger;
        this.reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
    }

    @Override
    public void run() {
        try {
            try {
                this.reader.lines().forEach(arg_0 -> ((Logger)this.logger).info(arg_0));
            }
            catch (UncheckedIOException e) {
                this.logger.error("while reading output", (Throwable)e);
            }
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                this.logger.error("caught i/o exception closing reader", (Throwable)e);
            }
        }
    }

    static void logOutput(Logger logger, Process process, String processName) {
        String threadName = (StringUtils.isNotBlank((CharSequence)processName) ? processName : "unknown") + ":" + ProcessOutputLogger.processId(process);
        Thread t = new Thread(new ProcessOutputLogger(logger, process));
        t.setName(threadName);
        t.setDaemon(true);
        t.start();
    }

    private static String processId(Process process) {
        try {
            return String.format("pid(%s)", MethodHandles.lookup().findVirtual(Process.class, "pid", MethodType.methodType(Long.TYPE)).invoke(process));
        }
        catch (Throwable throwable) {
            try {
                Field pid = process.getClass().getDeclaredField("pid");
                pid.setAccessible(true);
                return String.format("pid(%s)", pid.getInt(process));
            }
            catch (Exception exception) {
                return String.format("id(%s)", process.hashCode());
            }
        }
    }
}

