/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.derby;

import io.zonky.test.db.provider.support.AbstractEmbeddedDatabase;
import javax.sql.DataSource;

public class DerbyEmbeddedDatabase
extends AbstractEmbeddedDatabase {
    private final DataSource dataSource;
    private final String dbName;

    public DerbyEmbeddedDatabase(DataSource dataSource, String dbName, Runnable closeCallback) {
        super(closeCallback);
        this.dataSource = dataSource;
        this.dbName = dbName;
    }

    @Override
    protected DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getJdbcUrl() {
        return String.format("jdbc:derby:memory:%s;user=sa", this.dbName);
    }

    public String getDatabaseName() {
        return this.dbName;
    }
}

