/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway;

import io.zonky.test.db.flyway.FlywayVersion;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.flywaydb.core.Flyway;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StreamUtils;

public class FlywayClassUtils {
    private static final FlywayVersion flywayVersion = FlywayClassUtils.loadFlywayVersion();

    private FlywayClassUtils() {
    }

    private static FlywayVersion loadFlywayVersion() {
        try {
            ClassPathResource versionResource = new ClassPathResource("org/flywaydb/core/internal/version.txt", FlywayClassUtils.class.getClassLoader());
            if (versionResource.exists()) {
                String version = StreamUtils.copyToString((InputStream)versionResource.getInputStream(), (Charset)StandardCharsets.UTF_8);
                return FlywayVersion.parseVersion(version);
            }
            if (ClassUtils.hasMethod(Flyway.class, (String)"isPlaceholderReplacement", (Class[])new Class[0])) {
                return FlywayVersion.parseVersion("3.2");
            }
            if (ClassUtils.hasMethod(Flyway.class, (String)"getBaselineVersion", (Class[])new Class[0])) {
                return FlywayVersion.parseVersion("3.1");
            }
            return FlywayVersion.parseVersion("3.0");
        }
        catch (Exception e) {
            LoggerFactory.getLogger(FlywayClassUtils.class).error("Unexpected error when resolving flyway version", (Throwable)e);
            return FlywayVersion.parseVersion("0");
        }
    }

    public static FlywayVersion getFlywayVersion() {
        return flywayVersion;
    }
}

