/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.postgres;

import io.zonky.test.db.provider.support.AbstractEmbeddedDatabase;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;
import org.springframework.util.StringUtils;

public class PostgresEmbeddedDatabase
extends AbstractEmbeddedDatabase {
    private final PGSimpleDataSource dataSource;

    public PostgresEmbeddedDatabase(PGSimpleDataSource dataSource, Runnable closeCallback) {
        super(closeCallback);
        this.dataSource = dataSource;
    }

    @Override
    protected DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getJdbcUrl() {
        String url = this.dataSource.getUrl() + String.format("?user=%s", this.dataSource.getUser());
        if (StringUtils.hasText((String)this.dataSource.getPassword())) {
            url = url + String.format("&password=%s", this.dataSource.getPassword());
        }
        return url;
    }
}

