/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.common;

import io.zonky.test.db.preparer.CompositeDatabasePreparer;
import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.provider.DatabaseProvider;
import io.zonky.test.db.provider.EmbeddedDatabase;
import io.zonky.test.db.provider.ProviderException;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableList;
import io.zonky.test.db.shaded.com.google.common.collect.Sets;
import io.zonky.test.db.shaded.com.google.common.util.concurrent.AtomicLongMap;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizingDatabaseProvider
implements DatabaseProvider {
    public static final CompositeDatabasePreparer EMPTY_PREPARER = new CompositeDatabasePreparer(Collections.emptyList());
    private static final Logger logger = LoggerFactory.getLogger(OptimizingDatabaseProvider.class);
    private static final Set<BaselineKey> baselines = Sets.newConcurrentHashSet();
    private static final AtomicLongMap<BaselineKey> requestCount = AtomicLongMap.create();
    private final DatabaseProvider provider;

    public OptimizingDatabaseProvider(DatabaseProvider provider) {
        this.provider = provider;
    }

    @Override
    public EmbeddedDatabase createDatabase(DatabasePreparer preparer) throws ProviderException {
        int i;
        CompositeDatabasePreparer compositePreparer = preparer instanceof CompositeDatabasePreparer ? (CompositeDatabasePreparer)preparer : new CompositeDatabasePreparer(ImmutableList.of(preparer));
        List<DatabasePreparer> preparers = compositePreparer.getPreparers();
        for (i = preparers.size(); i > 0; --i) {
            requestCount.incrementAndGet(new BaselineKey(this.provider, new CompositeDatabasePreparer(preparers.subList(0, i))));
        }
        for (i = preparers.size(); i > 0; --i) {
            CompositeDatabasePreparer baselinePreparer = new CompositeDatabasePreparer(preparers.subList(0, i));
            BaselineKey baselineKey = new BaselineKey(this.provider, baselinePreparer);
            if (requestCount.get(baselineKey) >= 3L && !baselines.contains(baselineKey)) {
                logger.trace("Creating a new baseline preparer {} because the preparer has reached the maximum request threshold", (Object)baselinePreparer);
                baselines.add(baselineKey);
            }
            if (!baselines.contains(baselineKey)) continue;
            CompositeDatabasePreparer complementaryPreparer = new CompositeDatabasePreparer(preparers.subList(i, preparers.size()));
            if (i == preparers.size()) {
                logger.trace("Baseline preparer found, creating database by using the existing baseline preparer {}", (Object)baselinePreparer);
                return this.createDatabase(baselinePreparer, EMPTY_PREPARER);
            }
            if (this.hasSlowOperation(complementaryPreparer)) {
                logger.trace("Baseline preparer found {}, using the existing preparer to create a new baseline preparer {}", (Object)baselinePreparer, (Object)compositePreparer);
                baselines.add(new BaselineKey(this.provider, compositePreparer));
                return this.createDatabase(compositePreparer, EMPTY_PREPARER);
            }
            logger.trace("Baseline preparer found {}, creating database by using a complementary preparer {}", (Object)baselinePreparer, (Object)complementaryPreparer);
            return this.createDatabase(baselinePreparer, complementaryPreparer);
        }
        logger.trace("No baseline preparer found, creating database by using a new baseline preparer {}", (Object)compositePreparer);
        baselines.add(new BaselineKey(this.provider, compositePreparer));
        return this.createDatabase(compositePreparer, EMPTY_PREPARER);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptimizingDatabaseProvider that = (OptimizingDatabaseProvider)o;
        return Objects.equals(this.provider, that.provider);
    }

    public int hashCode() {
        return Objects.hash(this.provider);
    }

    private EmbeddedDatabase createDatabase(CompositeDatabasePreparer baselinePreparer, CompositeDatabasePreparer complementaryPreparer) {
        EmbeddedDatabase database = this.provider.createDatabase(baselinePreparer);
        try {
            complementaryPreparer.prepare(database);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unknown error when applying the preparer", e);
        }
        return database;
    }

    private boolean hasSlowOperation(CompositeDatabasePreparer preparer) {
        return preparer.estimatedDuration() > 150L;
    }

    private static class BaselineKey {
        private final DatabaseProvider provider;
        private final DatabasePreparer preparer;

        private BaselineKey(DatabaseProvider provider, DatabasePreparer preparer) {
            this.provider = provider;
            this.preparer = preparer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaselineKey that = (BaselineKey)o;
            return Objects.equals(this.provider, that.provider) && Objects.equals(this.preparer, that.preparer);
        }

        public int hashCode() {
            return Objects.hash(this.provider, this.preparer);
        }
    }
}

