/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.postgres;

import de.flapdoodle.embed.process.distribution.GenericVersion;
import de.flapdoodle.embed.process.distribution.IVersion;
import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.provider.DatabaseRequest;
import io.zonky.test.db.provider.DatabaseTemplate;
import io.zonky.test.db.provider.EmbeddedDatabase;
import io.zonky.test.db.provider.ProviderException;
import io.zonky.test.db.provider.TemplatableDatabaseProvider;
import io.zonky.test.db.provider.postgres.PostgresEmbeddedDatabase;
import io.zonky.test.db.provider.support.BlockingDatabaseWrapper;
import io.zonky.test.db.provider.support.SimpleDatabaseTemplate;
import io.zonky.test.db.shaded.com.google.common.base.Throwables;
import io.zonky.test.db.shaded.com.google.common.cache.CacheBuilder;
import io.zonky.test.db.shaded.com.google.common.cache.CacheLoader;
import io.zonky.test.db.shaded.com.google.common.cache.LoadingCache;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableMap;
import io.zonky.test.db.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import io.zonky.test.db.util.PropertyUtils;
import io.zonky.test.db.util.RandomStringUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.postgresql.ds.PGSimpleDataSource;
import org.postgresql.ds.common.BaseDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import ru.yandex.qatools.embed.postgresql.EmbeddedPostgres;
import ru.yandex.qatools.embed.postgresql.util.SocketUtil;

public class YandexPostgresDatabaseProvider
implements TemplatableDatabaseProvider {
    private static final Logger logger = LoggerFactory.getLogger(YandexPostgresDatabaseProvider.class);
    private static final String POSTGRES_USERNAME = "postgres";
    private static final String POSTGRES_PASSWORD = "yandex";
    private static final LoadingCache<DatabaseConfig, DatabaseInstance> databases = CacheBuilder.newBuilder().build(new CacheLoader<DatabaseConfig, DatabaseInstance>(){

        @Override
        public DatabaseInstance load(DatabaseConfig config) throws IOException {
            return new DatabaseInstance(config);
        }
    });
    private final DatabaseConfig databaseConfig;
    private final ClientConfig clientConfig;

    public YandexPostgresDatabaseProvider(Environment environment) {
        String postgresVersion = environment.getProperty("zonky.test.database.postgres.yandex-provider.postgres-version", "11.10-1");
        Map<String, String> initdbProperties = PropertyUtils.extractAll(environment, "zonky.test.database.postgres.initdb.properties");
        Map<String, String> configProperties = PropertyUtils.extractAll(environment, "zonky.test.database.postgres.server.properties");
        Map<String, String> connectProperties = PropertyUtils.extractAll(environment, "zonky.test.database.postgres.client.properties");
        this.databaseConfig = new DatabaseConfig((IVersion)new GenericVersion(postgresVersion), initdbProperties, configProperties);
        this.clientConfig = new ClientConfig(connectProperties);
    }

    @Override
    public DatabaseTemplate createTemplate(DatabaseRequest request) throws ProviderException {
        try {
            EmbeddedDatabase result = this.createDatabase(request);
            BaseDataSource dataSource = result.unwrap(BaseDataSource.class);
            return new SimpleDatabaseTemplate(dataSource.getDatabaseName(), result::close);
        }
        catch (SQLException e) {
            throw new ProviderException("Unexpected error when creating a database template", e);
        }
    }

    @Override
    public EmbeddedDatabase createDatabase(DatabaseRequest request) throws ProviderException {
        try {
            DatabaseInstance instance = databases.get(this.databaseConfig);
            return instance.createDatabase(this.clientConfig, request);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf(e.getCause(), ProviderException.class);
            throw new ProviderException("Unexpected error when preparing a database cluster", e.getCause());
        }
        catch (SQLException e) {
            throw new ProviderException("Unexpected error when creating a database", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        YandexPostgresDatabaseProvider that = (YandexPostgresDatabaseProvider)o;
        return Objects.equals(this.databaseConfig, that.databaseConfig) && Objects.equals(this.clientConfig, that.clientConfig);
    }

    public int hashCode() {
        return Objects.hash(this.databaseConfig, this.clientConfig);
    }

    private static class ClientConfig {
        private final Map<String, String> connectProperties;

        private ClientConfig(Map<String, String> connectProperties) {
            this.connectProperties = ImmutableMap.copyOf(connectProperties);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientConfig that = (ClientConfig)o;
            return Objects.equals(this.connectProperties, that.connectProperties);
        }

        public int hashCode() {
            return Objects.hash(this.connectProperties);
        }
    }

    private static class DatabaseConfig {
        private final IVersion version;
        private final Map<String, String> initdbProperties;
        private final Map<String, String> configProperties;

        private DatabaseConfig(IVersion version, Map<String, String> initdbProperties, Map<String, String> configProperties) {
            this.version = version;
            this.initdbProperties = ImmutableMap.copyOf(initdbProperties);
            this.configProperties = ImmutableMap.copyOf(configProperties);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatabaseConfig that = (DatabaseConfig)o;
            return Objects.equals(this.version, that.version) && Objects.equals(this.initdbProperties, that.initdbProperties) && Objects.equals(this.configProperties, that.configProperties);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.initdbProperties, this.configProperties);
        }
    }

    protected static class DatabaseInstance {
        private final EmbeddedPostgres postgres;
        private final Semaphore semaphore;

        private DatabaseInstance(DatabaseConfig config) throws IOException {
            HashMap<String, String> initdbProperties = new HashMap<String, String>(config.initdbProperties);
            initdbProperties.putIfAbsent("encoding", "UTF-8");
            List initdbParams = initdbProperties.entrySet().stream().map(e -> String.format("--%s=%s", e.getKey(), e.getValue())).collect(Collectors.toList());
            HashMap<String, String> serverProperties = new HashMap<String, String>(config.configProperties);
            serverProperties.putIfAbsent("max_connections", "300");
            List postgresParams = serverProperties.entrySet().stream().flatMap(e -> Stream.of("-c", String.format("%s=%s", e.getKey(), e.getValue()))).collect(Collectors.toList());
            this.postgres = new EmbeddedPostgres(config.version);
            this.postgres.start(EmbeddedPostgres.defaultRuntimeConfig(), "localhost", SocketUtil.findFreePort(), YandexPostgresDatabaseProvider.POSTGRES_USERNAME, YandexPostgresDatabaseProvider.POSTGRES_USERNAME, YandexPostgresDatabaseProvider.POSTGRES_PASSWORD, initdbParams, postgresParams);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((EmbeddedPostgres)this.postgres).close()));
            this.semaphore = new Semaphore(Integer.parseInt((String)serverProperties.get("max_connections")));
        }

        public EmbeddedDatabase createDatabase(ClientConfig config, DatabaseRequest request) throws SQLException {
            DatabaseTemplate template = request.getTemplate();
            DatabasePreparer preparer = request.getPreparer();
            String databaseName = RandomStringUtils.randomAlphabetic(12).toLowerCase(Locale.ENGLISH);
            if (template != null) {
                this.executeStatement(config, String.format("CREATE DATABASE %s TEMPLATE %s OWNER %s ENCODING 'utf8'", databaseName, template.getTemplateName(), YandexPostgresDatabaseProvider.POSTGRES_USERNAME));
            } else {
                this.executeStatement(config, String.format("CREATE DATABASE %s OWNER %s ENCODING 'utf8'", databaseName, YandexPostgresDatabaseProvider.POSTGRES_USERNAME));
            }
            try {
                EmbeddedDatabase database = this.getDatabase(config, databaseName);
                if (preparer != null) {
                    preparer.prepare(database);
                }
                return database;
            }
            catch (Exception e) {
                this.dropDatabase(config, databaseName);
                throw e;
            }
        }

        private void dropDatabase(ClientConfig config, String dbName) {
            CompletableFuture.runAsync(() -> {
                try {
                    this.executeStatement(config, String.format("DROP DATABASE IF EXISTS %s", dbName));
                }
                catch (Exception e) {
                    if (logger.isTraceEnabled()) {
                        logger.warn("Unable to release '{}' database", (Object)dbName, (Object)e);
                    }
                    logger.warn("Unable to release '{}' database", (Object)dbName);
                }
            });
        }

        private void executeStatement(ClientConfig config, String ddlStatement) throws SQLException {
            EmbeddedDatabase dataSource = this.getDatabase(config, YandexPostgresDatabaseProvider.POSTGRES_USERNAME);
            try (Connection connection = dataSource.getConnection();
                 PreparedStatement stmt = connection.prepareStatement(ddlStatement);){
                stmt.execute();
            }
        }

        private EmbeddedDatabase getDatabase(ClientConfig config, String dbName) throws SQLException {
            PGSimpleDataSource dataSource = new PGSimpleDataSource();
            dataSource.setServerName("localhost");
            dataSource.setPortNumber(this.postgres.getConfig().map(cfg -> cfg.net().port()).orElse(-1).intValue());
            dataSource.setDatabaseName(dbName);
            dataSource.setUser(YandexPostgresDatabaseProvider.POSTGRES_USERNAME);
            dataSource.setPassword(YandexPostgresDatabaseProvider.POSTGRES_PASSWORD);
            for (Map.Entry entry : config.connectProperties.entrySet()) {
                dataSource.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            return new BlockingDatabaseWrapper(new PostgresEmbeddedDatabase(dataSource, () -> this.dropDatabase(config, dbName)), this.semaphore);
        }
    }
}

