/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.logging;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.postgresql.ds.common.BaseDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedDatabaseReporter {
    private static final String JDBC_FORMAT = "jdbc:postgresql://localhost:%s/%s?user=%s";
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedDatabaseReporter.class);

    public static void reportDataSource(DataSource dataSource) {
        logger.info("JDBC URL to connect to the embedded database: {}", (Object)EmbeddedDatabaseReporter.getJdbcUrl(dataSource));
    }

    public static void reportDataSource(DataSource dataSource, AnnotatedElement element) {
        logger.info("JDBC URL to connect to the embedded database: {}, scope: {}", (Object)EmbeddedDatabaseReporter.getJdbcUrl(dataSource), (Object)EmbeddedDatabaseReporter.getElementName(element));
    }

    private static String getJdbcUrl(DataSource dataSource) {
        try {
            BaseDataSource ds = dataSource.unwrap(BaseDataSource.class);
            if (StringUtils.isBlank((CharSequence)ds.getPassword())) {
                return String.format(JDBC_FORMAT, ds.getPortNumber(), ds.getDatabaseName(), ds.getUser());
            }
            return String.format("jdbc:postgresql://localhost:%s/%s?user=%s&password=%s", ds.getPortNumber(), ds.getDatabaseName(), ds.getUser(), ds.getPassword());
        }
        catch (Exception e) {
            logger.warn("Unexpected error occurred while resolving url to the embedded database", (Throwable)e);
            return "unknown";
        }
    }

    private static String getElementName(AnnotatedElement element) {
        if (element instanceof Class) {
            return ((Class)element).getSimpleName();
        }
        if (element instanceof Method) {
            Method method = (Method)element;
            return EmbeddedDatabaseReporter.getElementName(method.getDeclaringClass()) + "#" + method.getName();
        }
        return element.toString();
    }
}

