/*
 * Copyright 2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.zonky.test.db.provider;

import com.google.common.base.MoreObjects;
import org.springframework.util.Assert;

import java.util.Objects;

public final class DatabaseDescriptor {

    private final DatabaseType databaseType;
    private final ProviderType providerType;

    public DatabaseDescriptor(DatabaseType databaseType, ProviderType providerType) {
        Assert.notNull(databaseType, "Database type must not be null");
        Assert.notNull(providerType, "Provider type must not be null");
        this.databaseType = databaseType;
        this.providerType = providerType;
    }

    public DatabaseType getDatabaseType() {
        return databaseType;
    }

    public ProviderType getProviderType() {
        return providerType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DatabaseDescriptor that = (DatabaseDescriptor) o;
        return Objects.equals(databaseType, that.databaseType) &&
                Objects.equals(providerType, that.providerType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(databaseType, providerType);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("databaseType", databaseType)
                .add("providerType", providerType)
                .toString();
    }
}
