/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class PropertyUtils {
    private PropertyUtils() {
    }

    public static Map<String, String> extractAll(Environment environment, String prefix) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (environment instanceof ConfigurableEnvironment) {
            for (PropertySource propertySource : ((ConfigurableEnvironment)environment).getPropertySources()) {
                if (!(propertySource instanceof EnumerablePropertySource)) continue;
                for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                    if (!key.startsWith(prefix)) continue;
                    properties.put(StringUtils.removeStart((String)key, (String)(prefix + ".")), String.valueOf(propertySource.getProperty(key)));
                }
            }
        }
        return properties;
    }
}

