/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.healthchecks.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.healthchecks.CheckResult;
import io.vertx.ext.healthchecks.HealthChecks;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.healthchecks.HealthCheckHandler;
import io.vertx.ext.web.healthchecks.impl.JsonCredentials;
import io.vertx.ext.web.impl.Utils;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class HealthCheckHandlerImpl
implements HealthCheckHandler {
    private final Logger log = LoggerFactory.getLogger(HealthCheckHandler.class);
    private final HealthChecks healthChecks;
    private final AuthenticationProvider authProvider;
    private volatile Function<CheckResult, Future<CheckResult>> resultMapper;

    public HealthCheckHandlerImpl(Vertx vertx, AuthenticationProvider provider) {
        this.healthChecks = HealthChecks.create((Vertx)vertx);
        this.authProvider = provider;
    }

    public HealthCheckHandlerImpl(HealthChecks hc, AuthenticationProvider provider) {
        this.healthChecks = Objects.requireNonNull(hc);
        this.authProvider = provider;
    }

    @Override
    public HealthCheckHandler register(String name, Handler<Promise<Status>> procedure) {
        this.healthChecks.register(name, procedure);
        return this;
    }

    @Override
    public HealthCheckHandler register(String name, long timeout, Handler<Promise<Status>> procedure) {
        this.healthChecks.register(name, timeout, procedure);
        return this;
    }

    @Override
    public HealthCheckHandler resultMapper(Function<CheckResult, Future<CheckResult>> resultMapper) {
        this.resultMapper = resultMapper;
        return this;
    }

    public void handle(RoutingContext rc) {
        String path = Utils.pathOffset(rc.normalizedPath(), rc);
        String id = path.length() > 0 ? path.substring(1) : path;
        if (this.authProvider != null) {
            JsonObject authData = new JsonObject();
            rc.request().headers().forEach(entry -> authData.put((String)entry.getKey(), entry.getValue()));
            rc.request().params().forEach(entry -> authData.put((String)entry.getKey(), entry.getValue()));
            if (rc.request().method() == HttpMethod.POST && rc.request().getHeader(HttpHeaders.CONTENT_TYPE) != null && rc.request().getHeader(HttpHeaders.CONTENT_TYPE).contains("application/json")) {
                try {
                    JsonObject body = rc.body().asJsonObject();
                    if (body != null) {
                        authData.mergeIn(body);
                    }
                }
                catch (Exception err2) {
                    this.log.error((Object)"Invalid authentication json body", (Throwable)err2);
                }
            }
            this.authProvider.authenticate((Credentials)new JsonCredentials(authData)).onFailure(err -> rc.response().setStatusCode(403).end()).onSuccess(user -> this.healthChecks.checkStatus(id).onComplete(this.healthReportHandler(rc)));
        } else {
            this.healthChecks.checkStatus(id).onComplete(this.healthReportHandler(rc));
        }
    }

    private Completable<CheckResult> healthReportHandler(RoutingContext rc) {
        Completable handler = (json, err) -> {
            HttpServerResponse response = rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json;charset=UTF-8");
            if (err != null) {
                if (err.getMessage().toLowerCase().contains("not found")) {
                    response.setStatusCode(404);
                } else {
                    response.setStatusCode(400);
                }
                response.end("{\"message\": \"" + err.getMessage() + "\"}");
            } else {
                this.buildResponse((CheckResult)json, response);
            }
        };
        if (this.resultMapper != null) {
            Promise promise = Promise.promise();
            promise.future().flatMap(this.resultMapper).onComplete(handler);
            return promise;
        }
        return handler;
    }

    private void buildResponse(CheckResult json, HttpServerResponse response) {
        int status;
        int n = status = CheckResult.isUp((CheckResult)json) ? 200 : 503;
        if (status == 503 && this.hasProcedureError(json)) {
            status = 500;
        }
        List checks = json.getChecks();
        if (status == 200 && checks != null && checks.isEmpty()) {
            response.setStatusCode(204).end();
            return;
        }
        response.setStatusCode(status).end(json.toJson().encode());
    }

    @Override
    public synchronized HealthCheckHandler unregister(String name) {
        this.healthChecks.unregister(name);
        return this;
    }

    private boolean hasProcedureError(CheckResult json) {
        JsonObject data = json.getData();
        if (data != null && data.getBoolean("procedure-execution-failure", Boolean.valueOf(false)).booleanValue()) {
            return true;
        }
        List checks = json.getChecks();
        if (checks != null) {
            for (CheckResult check : checks) {
                if (!this.hasProcedureError(check)) continue;
                return true;
            }
        }
        return false;
    }
}

