/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.CharTypes;
import io.vertx.core.json.EncodeException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JsonCodec {
    private static final JsonFactory factory = new JsonFactory();
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final int[] ESCAPE_CODES = CharTypes.get7BitOutputEscapes();

    private static void writeUnicodeEscape(JsonGenerator gen, char c) throws IOException {
        gen.writeRaw('\\');
        gen.writeRaw('u');
        gen.writeRaw(HEX_CHARS[c >> 12 & 0xF]);
        gen.writeRaw(HEX_CHARS[c >> 8 & 0xF]);
        gen.writeRaw(HEX_CHARS[c >> 4 & 0xF]);
        gen.writeRaw(HEX_CHARS[c & 0xF]);
    }

    private static void writeShortEscape(JsonGenerator gen, char c) throws IOException {
        gen.writeRaw('\\');
        gen.writeRaw(c);
    }

    public static String encode(String[] messages) throws EncodeException {
        String throwable2;
        block15: {
            StringWriter sw = new StringWriter();
            JsonGenerator gen = factory.createGenerator((Writer)sw);
            try {
                gen.writeStartArray();
                boolean first = true;
                for (String message : messages) {
                    if (first) {
                        first = false;
                    } else {
                        gen.writeRaw(',');
                    }
                    gen.writeRaw('\"');
                    for (char c : message.toCharArray()) {
                        int code;
                        if (c >= '\u0080') {
                            JsonCodec.writeUnicodeEscape(gen, c);
                            continue;
                        }
                        int n = code = c < ESCAPE_CODES.length ? ESCAPE_CODES[c] : 0;
                        if (code == 0) {
                            gen.writeRaw(c);
                            continue;
                        }
                        if (code == -1) {
                            JsonCodec.writeUnicodeEscape(gen, c);
                            continue;
                        }
                        JsonCodec.writeShortEscape(gen, (char)code);
                    }
                    gen.writeRaw('\"');
                }
                gen.writeEndArray();
                gen.close();
                throwable2 = sw.toString();
                if (gen == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (gen != null) {
                        try {
                            gen.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new EncodeException("Failed to encode as JSON", (Throwable)e);
                }
            }
            gen.close();
        }
        return throwable2;
    }

    public static List<String> decodeValues(String messages) {
        List<String> list;
        block13: {
            List<String> result = null;
            JsonParser parser = factory.createParser(messages);
            try {
                JsonToken jsonToken = parser.nextToken();
                if (jsonToken == JsonToken.START_ARRAY) {
                    while (parser.nextToken() != JsonToken.END_ARRAY) {
                        if (result == null) {
                            result = new ArrayList();
                        }
                        result.add(parser.getValueAsString());
                    }
                } else if (jsonToken == JsonToken.VALUE_STRING) {
                    result = Collections.singletonList(parser.getValueAsString());
                }
                List<String> list2 = list = result != null ? result : Collections.emptyList();
                if (parser == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ignore) {
                    return null;
                }
            }
            parser.close();
        }
        return list;
    }
}

