/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.internal.handler;

import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import java.util.Collections;
import java.util.List;

public interface ScopedAuthentication<SELF extends AuthenticationHandler> {
    public SELF withScope(String var1);

    public SELF withScopes(List<String> var1);

    default public List<String> getScopesOrSearchMetadata(List<String> scopes, RoutingContext ctx) {
        if (!scopes.isEmpty()) {
            return scopes;
        }
        Route currentRoute = ctx.currentRoute();
        if (currentRoute == null) {
            return Collections.emptyList();
        }
        Object value = currentRoute.metadata().get("scopes");
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof String) {
            return Collections.singletonList((String)value);
        }
        throw new IllegalStateException("Invalid type for scopes metadata: " + value.getClass().getName());
    }
}

