/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.web.RequestBody;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSession;
import java.util.Arrays;

class XhrTransport
extends BaseTransport {
    private static final Logger LOG = LoggerFactory.getLogger(XhrTransport.class);
    private static final Buffer H_BLOCK;

    XhrTransport(Vertx vertx, Router router, LocalMap<String, SockJSSession> sessions, SockJSHandlerOptions options, Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, options);
        String xhrBase = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/";
        String xhrRE = xhrBase + "xhr";
        String xhrStreamRE = xhrBase + "xhr_streaming";
        Handler<RoutingContext> xhrOptionsHandler = XhrTransport.createCORSOptionsHandler(options, "OPTIONS, POST");
        router.optionsWithRegex(xhrRE).handler(xhrOptionsHandler);
        router.optionsWithRegex(xhrStreamRE).handler(xhrOptionsHandler);
        this.registerHandler(router, sockHandler, xhrRE, false, options);
        this.registerHandler(router, sockHandler, xhrStreamRE, true, options);
        String xhrSendRE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/xhr_send";
        router.optionsWithRegex(xhrSendRE).handler(xhrOptionsHandler);
        router.postWithRegex(xhrSendRE).handler((Handler<RoutingContext>)((Handler)rc -> {
            String sessionID;
            SockJSSession session;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("XHR send, post, " + rc.request().uri()));
            }
            if ((session = (SockJSSession)sessions.get((Object)(sessionID = rc.request().getParam("param0")))) != null && !session.isClosed()) {
                this.handleSend((RoutingContext)rc, session);
            } else {
                rc.response().setStatusCode(404);
                XhrTransport.setJSESSIONID(options, rc);
                rc.response().end();
            }
        }));
    }

    private void registerHandler(Router router, Handler<SockJSSocket> sockHandler, String re, boolean streaming, SockJSHandlerOptions options) {
        router.postWithRegex(re).handler((Handler<RoutingContext>)((Handler)rc -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("XHR, post, " + rc.request().uri()));
            }
            XhrTransport.setNoCacheHeaders(rc);
            String sessionID = rc.request().getParam("param0");
            SockJSSession session = this.getSession((RoutingContext)rc, options, sessionID, sockHandler);
            HttpServerRequest req = rc.request();
            session.register(req, streaming ? new XhrStreamingListener(options.getMaxBytesStreaming(), (RoutingContext)rc, session) : new XhrPollingListener((RoutingContext)rc, session));
        }));
    }

    private void handleSend(RoutingContext rc, SockJSSession session) {
        RequestBody body = rc.body();
        if (!body.available()) {
            rc.fail(500, (Throwable)new NoStackTraceThrowable("BodyHandler is required to process POST requests"));
            return;
        }
        if (body.length() == 0) {
            rc.response().setStatusCode(500).end("Payload expected.");
            return;
        }
        if (!session.handleMessages(body.asString())) {
            this.sendInvalidJSON(rc.response());
        } else {
            rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain; charset=UTF-8");
            XhrTransport.setNoCacheHeaders(rc);
            XhrTransport.setJSESSIONID(this.options, rc);
            XhrTransport.setCORSIfNeeded(rc);
            rc.response().setStatusCode(204).end();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"XHR send processed ok");
        }
    }

    static {
        byte[] bytes = new byte[2049];
        Arrays.fill(bytes, 0, 2048, (byte)104);
        bytes[bytes.length - 1] = 10;
        H_BLOCK = Buffer.buffer((byte[])bytes);
    }

    private class XhrStreamingListener
    extends BaseXhrListener {
        int bytesSent;
        final int maxBytesStreaming;

        XhrStreamingListener(int maxBytesStreaming, RoutingContext rc, SockJSSession session) {
            super(rc, session);
            this.maxBytesStreaming = maxBytesStreaming;
            this.addCloseHandler(rc.response(), session);
        }

        @Override
        public void sendFrame(String body, Handler<AsyncResult<Void>> handler) {
            boolean hr = this.headersWritten;
            super.beforeSend();
            if (!hr) {
                this.rc.response().write((Object)H_BLOCK);
            }
            String sbody = body + "\n";
            Buffer buff = Buffer.buffer((String)sbody);
            this.rc.response().write((Object)buff, handler);
            this.bytesSent += buff.length();
            if (this.bytesSent >= this.maxBytesStreaming) {
                this.close();
            }
        }

        @Override
        public void close() {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"XHR stream closing listener");
            }
            if (!this.closed) {
                this.session.resetListener();
                try {
                    this.rc.response().end();
                    this.rc.response().close();
                    this.closed = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    private class XhrPollingListener
    extends BaseXhrListener {
        XhrPollingListener(RoutingContext rc, SockJSSession session) {
            super(rc, session);
            this.addCloseHandler(rc.response(), session);
        }

        @Override
        public void sendFrame(String body, Handler<AsyncResult<Void>> handler) {
            super.beforeSend();
            this.rc.response().write(body + "\n", handler);
            this.close();
        }

        @Override
        public void close() {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"XHR poll closing listener");
            }
            if (!this.closed) {
                try {
                    this.session.resetListener();
                    this.rc.response().end();
                    this.rc.response().close();
                    this.closed = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    private abstract class BaseXhrListener
    extends BaseTransport.BaseListener {
        boolean headersWritten;

        BaseXhrListener(RoutingContext rc, SockJSSession session) {
            super(rc, session);
        }

        final void beforeSend() {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"XHR sending frame");
            }
            if (!this.headersWritten) {
                HttpServerResponse resp = this.rc.response();
                resp.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/javascript; charset=UTF-8");
                BaseTransport.setJSESSIONID(XhrTransport.this.options, this.rc);
                BaseTransport.setCORSIfNeeded(this.rc);
                if (this.rc.request().version() != HttpVersion.HTTP_1_0) {
                    resp.setChunked(true);
                }
                this.headersWritten = true;
            }
        }

        @Override
        public void close() {
        }
    }
}

