/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.Oauth2Credentials;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import io.vertx.ext.web.handler.impl.ScopedAuthentication;
import io.vertx.ext.web.impl.OrderListener;
import io.vertx.ext.web.impl.Origin;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OAuth2AuthHandlerImpl
extends HTTPAuthorizationHandler<OAuth2Auth>
implements OAuth2AuthHandler,
ScopedAuthentication<OAuth2AuthHandler>,
OrderListener {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2AuthHandlerImpl.class);
    private final VertxContextPRNG prng;
    private final Origin callbackURL;
    private final MessageDigest sha256;
    private final List<String> scopes;
    private final boolean openId;
    private JsonObject extraParams;
    private String prompt;
    private int pkce = -1;
    private boolean bearerOnly = true;
    private int order = -1;
    private Route callback;
    private static final Set<String> OPENID_SCOPES = new HashSet<String>();

    public OAuth2AuthHandlerImpl(Vertx vertx, OAuth2Auth authProvider, String callbackURL) {
        this(vertx, authProvider, callbackURL, null);
    }

    public OAuth2AuthHandlerImpl(Vertx vertx, OAuth2Auth authProvider, String callbackURL, String realm) {
        super(authProvider, HTTPAuthorizationHandler.Type.BEARER, realm);
        this.prng = VertxContextPRNG.current((Vertx)vertx);
        try {
            this.sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot get instance of SHA-256 MessageDigest", e);
        }
        this.callbackURL = callbackURL != null ? Origin.parse(callbackURL) : null;
        this.scopes = new ArrayList<String>();
        this.openId = false;
    }

    private OAuth2AuthHandlerImpl(OAuth2AuthHandlerImpl base, List<String> scopes) {
        super(base.authProvider, HTTPAuthorizationHandler.Type.BEARER, base.realm);
        this.prng = base.prng;
        this.callbackURL = base.callbackURL;
        this.prompt = base.prompt;
        this.pkce = base.pkce;
        this.bearerOnly = base.bearerOnly;
        try {
            this.sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot get instance of SHA-256 MessageDigest", e);
        }
        if (base.extraParams != null) {
            this.extraParams = this.extraParams.copy();
        }
        this.scopes = scopes;
        this.openId = scopes != null && scopes.contains("openid");
    }

    @Override
    public void authenticate(RoutingContext context, Handler<AsyncResult<User>> handler) {
        this.parseAuthorization(context, !this.bearerOnly, (Handler<AsyncResult<String>>)((Handler)parseAuthorization -> {
            if (parseAuthorization.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)parseAuthorization.cause()));
                return;
            }
            String token = (String)parseAuthorization.result();
            if (token == null) {
                if (this.bearerOnly) {
                    handler.handle((Object)Future.failedFuture((String)"callback route is not configured."));
                    return;
                }
                if (context.request().method() == HttpMethod.GET && context.normalizedPath().equals(this.callbackURL.resource())) {
                    LOG.warn((Object)"The callback route is shaded by the OAuth2AuthHandler, ensure the callback route is added BEFORE the OAuth2AuthHandler route!");
                    handler.handle((Object)Future.failedFuture((Throwable)new HttpException(500, "Infinite redirect loop [oauth2 callback]")));
                } else {
                    if (context.request().method() != HttpMethod.GET) {
                        LOG.error((Object)"OAuth2 redirect attempt to non GET resource");
                        context.fail(405, new IllegalStateException("OAuth2 redirect attempt to non GET resource"));
                        return;
                    }
                    String redirectUri = context.request().uri();
                    String state = null;
                    String codeVerifier = null;
                    Session session = context.session();
                    if (session == null) {
                        if (this.pkce > 0) {
                            context.fail(500, new IllegalStateException("OAuth2 PKCE requires a session to be present"));
                            return;
                        }
                    } else {
                        session.put("redirect_uri", context.request().uri());
                        state = this.prng.nextString(6);
                        session.put("state", state);
                        if (this.pkce > 0) {
                            codeVerifier = this.prng.nextString(this.pkce);
                            session.put("pkce", codeVerifier);
                        }
                    }
                    handler.handle((Object)Future.failedFuture((Throwable)new HttpException(302, this.authURI(redirectUri, state, codeVerifier))));
                }
            } else {
                TokenCredentials credentials = this.scopes.size() > 0 ? new TokenCredentials(token).setScopes(this.scopes) : new TokenCredentials(token);
                ((OAuth2Auth)this.authProvider).authenticate((Credentials)credentials, authn -> {
                    if (authn.failed()) {
                        handler.handle((Object)Future.failedFuture((Throwable)new HttpException(401, authn.cause())));
                    } else {
                        handler.handle(authn);
                    }
                });
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String authURI(String redirectURL, String state, String codeVerifier) {
        JsonObject config = new JsonObject();
        if (this.extraParams != null) {
            config.mergeIn(this.extraParams);
        }
        config.put("state", (Object)(state != null ? state : redirectURL));
        if (this.callbackURL != null) {
            config.put("redirect_uri", (Object)this.callbackURL.href());
        }
        if (this.scopes.size() > 0) {
            config.put("scopes", this.scopes);
        }
        if (this.prompt != null) {
            config.put("prompt", (Object)this.prompt);
        }
        if (codeVerifier != null) {
            MessageDigest messageDigest = this.sha256;
            synchronized (messageDigest) {
                this.sha256.update(codeVerifier.getBytes(StandardCharsets.US_ASCII));
                config.put("code_challenge", (Object)this.sha256.digest()).put("code_challenge_method", (Object)"S256");
            }
        }
        return ((OAuth2Auth)this.authProvider).authorizeURL(config);
    }

    @Override
    public OAuth2AuthHandler extraParams(JsonObject extraParams) {
        this.extraParams = extraParams;
        return this;
    }

    @Override
    public OAuth2AuthHandler withScope(String scope) {
        ArrayList<String> updatedScopes = new ArrayList<String>(this.scopes);
        updatedScopes.add(scope);
        return new OAuth2AuthHandlerImpl(this, updatedScopes);
    }

    @Override
    public OAuth2AuthHandler withScopes(List<String> scopes) {
        return new OAuth2AuthHandlerImpl(this, scopes);
    }

    @Override
    public OAuth2AuthHandler prompt(String prompt) {
        this.prompt = prompt;
        return this;
    }

    @Override
    public OAuth2AuthHandler pkceVerifierLength(int length) {
        if (length >= 0 && (length < 43 || length > 128)) {
            throw new IllegalArgumentException("Length must be between 34 and 128");
        }
        this.pkce = length;
        return this;
    }

    @Override
    public OAuth2AuthHandler setupCallback(Route route) {
        if (this.callbackURL == null) {
            throw new IllegalStateException("OAuth2AuthHandler was created without a origin/callback URL");
        }
        String routePath = route.getPath();
        if (routePath == null) {
            throw new IllegalStateException("OAuth2AuthHandler callback route created without a path");
        }
        String callbackPath = this.callbackURL.resource();
        if (callbackPath != null && !"".equals(callbackPath) && !callbackPath.endsWith(routePath) && LOG.isWarnEnabled()) {
            LOG.warn((Object)"callback route doesn't match OAuth2AuthHandler origin configuration");
        }
        this.callback = route;
        if (this.order != -1) {
            this.mountCallback();
        }
        this.bearerOnly = false;
        return this;
    }

    @Override
    public void postAuthentication(RoutingContext ctx) {
        if (this.scopes != null && this.scopes.size() > 0) {
            String scopes;
            User user = ctx.user();
            if (user == null) {
                ctx.fail(403, new IllegalStateException("no user in the context"));
                return;
            }
            if (user.principal().containsKey("scope") && (scopes = user.principal().getString("scope")) != null) {
                for (String scope : this.scopes) {
                    if (this.openId && OPENID_SCOPES.contains(scope)) continue;
                    int idx = scopes.indexOf(scope);
                    if (idx != -1) {
                        if ((idx == 0 || scopes.charAt(idx - 1) == ' ') && (idx + scope.length() == scopes.length() || scopes.charAt(idx + scope.length()) == ' ')) continue;
                        ctx.fail(403, new IllegalStateException("principal scope != handler scopes"));
                        return;
                    }
                    ctx.fail(403, new IllegalStateException("principal scope != handler scopes"));
                    return;
                }
            }
        }
        ctx.next();
    }

    @Override
    public boolean performsRedirect() {
        if (!this.bearerOnly) {
            return true;
        }
        return this.callbackURL != null;
    }

    @Override
    public void onOrder(int order) {
        this.order = order;
        if (this.callback != null) {
            this.mountCallback();
        }
    }

    private void mountCallback() {
        this.callback.method(HttpMethod.GET).order(this.order - 1);
        this.callback.handler((Handler<RoutingContext>)((Handler)ctx -> {
            String resource;
            String error = ctx.request().getParam("error");
            if (error != null) {
                int errorCode;
                switch (error) {
                    case "invalid_token": {
                        errorCode = 401;
                        break;
                    }
                    case "insufficient_scope": {
                        errorCode = 403;
                        break;
                    }
                    default: {
                        errorCode = 400;
                    }
                }
                String errorDescription = ctx.request().getParam("error_description");
                if (errorDescription != null) {
                    ctx.fail(errorCode, new IllegalStateException(error + ": " + errorDescription));
                } else {
                    ctx.fail(errorCode, new IllegalStateException(error));
                }
                return;
            }
            String code = ctx.request().getParam("code");
            if (code == null) {
                ctx.fail(400, new IllegalStateException("Missing code parameter"));
                return;
            }
            Oauth2Credentials credentials = new Oauth2Credentials().setCode(code);
            String state = ctx.request().getParam("state");
            if (state == null) {
                ctx.fail(400, new IllegalStateException("Missing IdP state parameter to the callback endpoint"));
                return;
            }
            Session session = ctx.session();
            if (session != null) {
                String ctxState = (String)session.remove("state");
                if (!state.equals(ctxState)) {
                    ctx.fail(401, new IllegalStateException("Invalid oauth2 state"));
                    return;
                }
                String codeVerifier = (String)session.remove("pkce");
                credentials.setCodeVerifier(codeVerifier);
                resource = (String)session.get("redirect_uri");
            } else {
                resource = state;
            }
            credentials.setRedirectUri(this.callbackURL.href());
            ((OAuth2Auth)this.authProvider).authenticate((Credentials)credentials, res -> {
                if (res.failed()) {
                    ctx.fail(res.cause());
                } else {
                    String location;
                    ctx.setUser((User)res.result());
                    String string = location = resource != null ? resource : "/";
                    if (session != null) {
                        session.regenerateId();
                    } else if (location.length() != 0 && location.charAt(0) == '/') {
                        ctx.reroute(location);
                        return;
                    }
                    ctx.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-cache, no-store, must-revalidate").putHeader("Pragma", "no-cache").putHeader(HttpHeaders.EXPIRES, (CharSequence)"0").putHeader(HttpHeaders.LOCATION, (CharSequence)location).setStatusCode(302).end("Redirecting to " + location + ".");
                }
            });
        }));
    }

    static {
        OPENID_SCOPES.add("openid");
        OPENID_SCOPES.add("profile");
        OPENID_SCOPES.add("email");
        OPENID_SCOPES.add("phone");
        OPENID_SCOPES.add("offline");
    }
}

