/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.impl.FileUploadImpl;
import java.io.File;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class BodyHandlerImpl
implements BodyHandler {
    private static final Logger log = LoggerFactory.getLogger(BodyHandlerImpl.class);
    private static final String BODY_HANDLED = "__body-handled";
    private long bodyLimit = -1L;
    private boolean handleFileUploads;
    private String uploadsDir;
    private boolean mergeFormAttributes = true;
    private boolean deleteUploadedFilesOnEnd = false;
    private boolean isPreallocateBodyBuffer = false;
    private static final int DEFAULT_INITIAL_BODY_BUFFER_SIZE = 1024;

    public BodyHandlerImpl() {
        this(true, "file-uploads");
    }

    public BodyHandlerImpl(boolean handleFileUploads) {
        this(handleFileUploads, "file-uploads");
    }

    public BodyHandlerImpl(String uploadDirectory) {
        this(true, uploadDirectory);
    }

    private BodyHandlerImpl(boolean handleFileUploads, String uploadDirectory) {
        this.handleFileUploads = handleFileUploads;
        this.setUploadsDirectory(uploadDirectory);
    }

    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        if (request.headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true)) {
            context.next();
            return;
        }
        Boolean handled = (Boolean)context.get(BODY_HANDLED);
        if (handled == null || !handled.booleanValue()) {
            long contentLength = this.isPreallocateBodyBuffer ? this.parseContentLengthHeader(request) : -1L;
            BHandler handler = new BHandler(context, contentLength);
            request.handler((Handler)handler);
            request.endHandler(v -> handler.end());
            context.put(BODY_HANDLED, true);
        } else {
            if (this.mergeFormAttributes && request.isExpectMultipart()) {
                request.params().addAll(request.formAttributes());
            }
            context.next();
        }
    }

    @Override
    public BodyHandler setHandleFileUploads(boolean handleFileUploads) {
        this.handleFileUploads = handleFileUploads;
        return this;
    }

    @Override
    public BodyHandler setBodyLimit(long bodyLimit) {
        this.bodyLimit = bodyLimit;
        return this;
    }

    @Override
    public BodyHandler setUploadsDirectory(String uploadsDirectory) {
        this.uploadsDir = uploadsDirectory;
        return this;
    }

    @Override
    public BodyHandler setMergeFormAttributes(boolean mergeFormAttributes) {
        this.mergeFormAttributes = mergeFormAttributes;
        return this;
    }

    @Override
    public BodyHandler setDeleteUploadedFilesOnEnd(boolean deleteUploadedFilesOnEnd) {
        this.deleteUploadedFilesOnEnd = deleteUploadedFilesOnEnd;
        return this;
    }

    @Override
    public BodyHandler setPreallocateBodyBuffer(boolean isPreallocateBodyBuffer) {
        this.isPreallocateBodyBuffer = isPreallocateBodyBuffer;
        return this;
    }

    private long parseContentLengthHeader(HttpServerRequest request) {
        String contentLength = request.getHeader(HttpHeaders.CONTENT_LENGTH);
        if (contentLength == null || contentLength.isEmpty()) {
            return -1L;
        }
        try {
            long parsedContentLength = Long.parseLong(contentLength);
            return parsedContentLength < 0L ? -1L : parsedContentLength;
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    private class BHandler
    implements Handler<Buffer> {
        private static final int MAX_PREALLOCATED_BODY_BUFFER_BYTES = 65535;
        RoutingContext context;
        Buffer body;
        boolean failed;
        AtomicInteger uploadCount = new AtomicInteger();
        AtomicBoolean cleanup = new AtomicBoolean(false);
        boolean ended;
        long uploadSize = 0L;
        final boolean isMultipart;
        final boolean isUrlEncoded;

        public BHandler(RoutingContext context, long contentLength) {
            this.context = context;
            Set<FileUpload> fileUploads = context.fileUploads();
            String contentType = context.request().getHeader(HttpHeaders.CONTENT_TYPE);
            if (contentType == null) {
                this.isMultipart = false;
                this.isUrlEncoded = false;
            } else {
                String lowerCaseContentType = contentType.toLowerCase();
                this.isMultipart = lowerCaseContentType.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString());
                this.isUrlEncoded = lowerCaseContentType.startsWith(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString());
            }
            this.initBodyBuffer(contentLength);
            if (this.isMultipart || this.isUrlEncoded) {
                context.request().setExpectMultipart(true);
                if (BodyHandlerImpl.this.handleFileUploads) {
                    this.makeUploadDir(context.vertx().fileSystem());
                }
                context.request().uploadHandler(upload -> {
                    long size;
                    if (BodyHandlerImpl.this.bodyLimit != -1L && upload.isSizeAvailable() && (size = this.uploadSize + upload.size()) > BodyHandlerImpl.this.bodyLimit) {
                        this.failed = true;
                        context.fail(413);
                        return;
                    }
                    if (BodyHandlerImpl.this.handleFileUploads) {
                        this.uploadCount.incrementAndGet();
                        String uploadedFileName = new File(BodyHandlerImpl.this.uploadsDir, UUID.randomUUID().toString()).getPath();
                        upload.streamToFileSystem(uploadedFileName);
                        FileUploadImpl fileUpload = new FileUploadImpl(uploadedFileName, (HttpServerFileUpload)upload);
                        fileUploads.add(fileUpload);
                        upload.exceptionHandler(t -> {
                            this.deleteFileUploads();
                            context.fail((Throwable)t);
                        });
                        upload.endHandler(v -> this.uploadEnded());
                    }
                });
            }
            context.request().exceptionHandler(t -> {
                this.deleteFileUploads();
                context.fail((Throwable)t);
            });
        }

        private void initBodyBuffer(long contentLength) {
            int initialBodyBufferSize = contentLength < 0L ? 1024 : (contentLength > 65535L ? 65535 : (int)contentLength);
            if (BodyHandlerImpl.this.bodyLimit != -1L) {
                initialBodyBufferSize = (int)Math.min((long)initialBodyBufferSize, BodyHandlerImpl.this.bodyLimit);
            }
            this.body = Buffer.buffer((int)initialBodyBufferSize);
        }

        private void makeUploadDir(FileSystem fileSystem) {
            if (!fileSystem.existsBlocking(BodyHandlerImpl.this.uploadsDir)) {
                fileSystem.mkdirsBlocking(BodyHandlerImpl.this.uploadsDir);
            }
        }

        public void handle(Buffer buff) {
            if (this.failed) {
                return;
            }
            this.uploadSize += (long)buff.length();
            if (BodyHandlerImpl.this.bodyLimit != -1L && this.uploadSize > BodyHandlerImpl.this.bodyLimit) {
                this.failed = true;
                this.context.fail(413);
                this.context.vertx().runOnContext(v -> this.deleteFileUploads());
            } else if (!this.isMultipart) {
                this.body.appendBuffer(buff);
            }
        }

        void uploadEnded() {
            int count = this.uploadCount.decrementAndGet();
            if (this.ended && count == 0) {
                this.doEnd();
            }
        }

        void end() {
            this.ended = true;
            if (this.uploadCount.get() == 0) {
                this.doEnd();
            }
        }

        void doEnd() {
            if (this.failed) {
                this.deleteFileUploads();
                return;
            }
            if (BodyHandlerImpl.this.deleteUploadedFilesOnEnd) {
                this.context.addBodyEndHandler((Handler<Void>)((Handler)x -> this.deleteFileUploads()));
            }
            HttpServerRequest req = this.context.request();
            if (BodyHandlerImpl.this.mergeFormAttributes && req.isExpectMultipart()) {
                req.params().addAll(req.formAttributes());
            }
            this.context.setBody(this.body);
            this.context.next();
        }

        private void deleteFileUploads() {
            if (this.cleanup.compareAndSet(false, true) && BodyHandlerImpl.this.handleFileUploads) {
                for (FileUpload fileUpload : this.context.fileUploads()) {
                    FileSystem fileSystem = this.context.vertx().fileSystem();
                    String uploadedFileName = fileUpload.uploadedFileName();
                    fileSystem.exists(uploadedFileName, existResult -> {
                        if (existResult.failed()) {
                            log.warn((Object)("Could not detect if uploaded file exists, not deleting: " + uploadedFileName), existResult.cause());
                        } else if (((Boolean)existResult.result()).booleanValue()) {
                            fileSystem.delete(uploadedFileName, deleteResult -> {
                                if (deleteResult.failed()) {
                                    log.warn((Object)("Delete of uploaded file failed: " + uploadedFileName), deleteResult.cause());
                                }
                            });
                        }
                    });
                }
            }
        }
    }
}

