/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.impl.URIDecoder;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.BlockingHandlerDecorator;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import io.vertx.ext.web.impl.RouterImpl;
import io.vertx.ext.web.impl.RoutingContextImplBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RouteImpl
implements Route {
    private static final Logger log = LoggerFactory.getLogger(RouteImpl.class);
    private final RouterImpl router;
    private final Set<HttpMethod> methods = new HashSet<HttpMethod>();
    private final Set<MIMEHeader> consumes = new LinkedHashSet<MIMEHeader>();
    private boolean emptyBodyPermittedWithConsumes = false;
    private final Set<MIMEHeader> produces = new LinkedHashSet<MIMEHeader>();
    private String path;
    private int order;
    private boolean enabled = true;
    private List<Handler<RoutingContext>> contextHandlers;
    private List<Handler<RoutingContext>> failureHandlers;
    private boolean added;
    private Pattern pattern;
    private List<String> groups;
    private boolean useNormalisedPath = true;
    private Set<String> namedGroupsInRegex = new TreeSet<String>();
    private boolean pathEndsWithSlash;
    private boolean exclusive;
    private static final Pattern RE_OPERATORS_NO_STAR = Pattern.compile("([\\(\\)\\$\\+\\.])");
    private static final Pattern RE_TOKEN_SEARCH = Pattern.compile(":([A-Za-z][A-Za-z0-9_]*)");
    private boolean exactPath;

    RouteImpl(RouterImpl router, int order) {
        this.router = router;
        this.order = order;
        this.contextHandlers = new ArrayList<Handler<RoutingContext>>();
        this.failureHandlers = new ArrayList<Handler<RoutingContext>>();
    }

    RouteImpl(RouterImpl router, int order, HttpMethod method, String path) {
        this(router, order);
        this.methods.add(method);
        this.checkPath(path);
        this.setPath(path);
    }

    RouteImpl(RouterImpl router, int order, String path) {
        this(router, order);
        this.checkPath(path);
        this.setPath(path);
    }

    RouteImpl(RouterImpl router, int order, HttpMethod method, String regex, boolean bregex) {
        this(router, order);
        this.methods.add(method);
        this.setRegex(regex);
    }

    RouteImpl(RouterImpl router, int order, String regex, boolean bregex) {
        this(router, order);
        this.setRegex(regex);
    }

    @Override
    public synchronized Route method(HttpMethod method) {
        this.methods.add(method);
        return this;
    }

    @Override
    public synchronized Route path(String path) {
        this.checkPath(path);
        this.setPath(path);
        return this;
    }

    @Override
    public synchronized Route pathRegex(String regex) {
        this.setRegex(regex);
        return this;
    }

    @Override
    public synchronized Route produces(String contentType) {
        ParsableMIMEValue value = new ParsableMIMEValue(contentType).forceParse();
        this.produces.add(value);
        return this;
    }

    @Override
    public synchronized Route consumes(String contentType) {
        ParsableMIMEValue value = new ParsableMIMEValue(contentType).forceParse();
        this.consumes.add(value);
        return this;
    }

    @Override
    public synchronized Route order(int order) {
        if (this.added) {
            throw new IllegalStateException("Can't change order after route is active");
        }
        this.order = order;
        return this;
    }

    @Override
    public synchronized Route last() {
        return this.order(Integer.MAX_VALUE);
    }

    @Override
    public synchronized Route handler(Handler<RoutingContext> contextHandler) {
        if (this.exclusive) {
            throw new IllegalStateException("This Route is exclusive for already mounted sub router.");
        }
        this.contextHandlers.add(contextHandler);
        this.checkAdd();
        return this;
    }

    @Override
    public Route blockingHandler(Handler<RoutingContext> contextHandler) {
        return this.blockingHandler(contextHandler, true);
    }

    @Override
    public Route subRouter(Router subRouter) {
        if (this.exactPath) {
            throw new IllegalStateException("Sub router cannot be mounted on an exact path.");
        }
        if (this.path == null && this.pattern != null) {
            throw new IllegalStateException("Sub router cannot be mounted on a regular expression path.");
        }
        if (this.contextHandlers.size() > 0 || this.failureHandlers.size() > 0) {
            throw new IllegalStateException("Only one sub router per Route object is allowed.");
        }
        this.handler((Handler<RoutingContext>)((Handler)subRouter::handleContext));
        this.failureHandler((Handler<RoutingContext>)((Handler)subRouter::handleFailure));
        subRouter.modifiedHandler((Handler<Router>)((Handler)this::validateMount));
        this.validateMount(subRouter);
        this.exclusive = true;
        return this;
    }

    @Override
    public synchronized Route blockingHandler(Handler<RoutingContext> contextHandler, boolean ordered) {
        return this.handler(new BlockingHandlerDecorator(contextHandler, ordered));
    }

    @Override
    public synchronized Route failureHandler(Handler<RoutingContext> exceptionHandler) {
        if (this.exclusive) {
            throw new IllegalStateException("This Route is exclusive for already mounted sub router.");
        }
        this.failureHandlers.add(exceptionHandler);
        this.checkAdd();
        return this;
    }

    @Override
    public synchronized Route remove() {
        this.router.remove(this);
        return this;
    }

    @Override
    public synchronized Route disable() {
        this.enabled = false;
        return this;
    }

    @Override
    public synchronized Route enable() {
        this.enabled = true;
        return this;
    }

    @Override
    public Route useNormalisedPath(boolean useNormalisedPath) {
        this.useNormalisedPath = useNormalisedPath;
        return this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isRegexPath() {
        return this.pattern != null;
    }

    @Override
    public Set<HttpMethod> methods() {
        return this.methods;
    }

    @Override
    public Route setRegexGroupsNames(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Route[ ");
        sb.append("path:").append(this.path);
        sb.append(" pattern:").append(this.pattern);
        sb.append(" handlers:").append(this.contextHandlers);
        sb.append(" failureHandlers:").append(this.failureHandlers);
        sb.append(" order:").append(this.order);
        sb.append(" methods:[");
        int cnt = 0;
        for (HttpMethod method : this.methods) {
            sb.append(method);
            if (++cnt >= this.methods.size()) continue;
            sb.append(",");
        }
        sb.append("]]@").append(System.identityHashCode(this));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleContext(RoutingContextImplBase context) {
        Handler<RoutingContext> contextHandler;
        RouteImpl routeImpl = this;
        synchronized (routeImpl) {
            contextHandler = this.contextHandlers.get(context.currentRouteNextHandlerIndex() - 1);
        }
        contextHandler.handle((Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleFailure(RoutingContextImplBase context) {
        Handler<RoutingContext> failureHandler;
        RouteImpl routeImpl = this;
        synchronized (routeImpl) {
            failureHandler = this.failureHandlers.get(context.currentRouteNextFailureHandlerIndex() - 1);
        }
        failureHandler.handle((Object)context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized int matches(RoutingContextImplBase context, String mountPoint, boolean failure) {
        MIMEHeader contentType;
        MIMEHeader consumal;
        if (failure && !this.hasNextFailureHandler(context) || !failure && !this.hasNextContextHandler(context)) {
            return 404;
        }
        if (!this.enabled) {
            return 404;
        }
        HttpServerRequest request = context.request();
        if (this.path != null && this.pattern == null && !this.pathMatches(mountPoint, context)) {
            return 404;
        }
        if (this.pattern != null) {
            Matcher m;
            String path;
            String string = path = this.useNormalisedPath ? context.normalisedPath() : context.request().path();
            if (mountPoint != null) {
                path = path.substring(mountPoint.length());
            }
            if (!(m = this.pattern.matcher(path)).matches()) return 404;
            if (!this.methods.isEmpty() && !this.methods.contains(request.method())) {
                return 405;
            }
            context.matchRest = -1;
            context.matchNormalized = this.useNormalisedPath;
            if (m.groupCount() > 0) {
                if (!this.exactPath) {
                    context.matchRest = m.start("rest");
                }
                if (this.groups != null) {
                    for (int i = 0; i < Math.min(this.groups.size(), m.groupCount()); ++i) {
                        String undecodedValue;
                        String k = this.groups.get(i);
                        try {
                            undecodedValue = m.group("p" + i);
                        }
                        catch (IllegalArgumentException e) {
                            try {
                                undecodedValue = m.group(k);
                            }
                            catch (IllegalArgumentException e1) {
                                undecodedValue = m.group(i + 1);
                            }
                        }
                        this.addPathParam(context, k, undecodedValue);
                    }
                } else {
                    for (String namedGroup : this.namedGroupsInRegex) {
                        String namedGroupValue = m.group(namedGroup);
                        if (namedGroupValue == null) continue;
                        this.addPathParam(context, namedGroup, namedGroupValue);
                    }
                    for (int i = 0; i < m.groupCount(); ++i) {
                        String group = m.group(i + 1);
                        if (group == null) continue;
                        String k = "param" + i;
                        this.addPathParam(context, k, group);
                    }
                }
            }
        } else if (!this.methods.isEmpty() && !this.methods.contains(request.method())) {
            return 405;
        }
        if (!(this.consumes.isEmpty() || (consumal = (contentType = context.parsedHeaders().contentType()).findMatchedBy(this.consumes)) != null || contentType.rawValue().isEmpty() && this.emptyBodyPermittedWithConsumes)) {
            if (!contentType.rawValue().isEmpty()) return 415;
            return 400;
        }
        List<MIMEHeader> acceptableTypes = context.parsedHeaders().accept();
        if (this.produces.isEmpty() || acceptableTypes.isEmpty()) return 0;
        MIMEHeader selectedAccept = context.parsedHeaders().findBestUserAcceptedIn(acceptableTypes, this.produces);
        if (selectedAccept == null) return 406;
        context.setAcceptableContentType(selectedAccept.rawValue());
        return 0;
    }

    private void addPathParam(RoutingContext context, String name, String value) {
        HttpServerRequest request = context.request();
        String decodedValue = URIDecoder.decodeURIComponent((String)value, (boolean)false);
        if (!request.params().contains(name)) {
            request.params().add(name, decodedValue);
        }
        context.pathParams().put(name, decodedValue);
    }

    RouterImpl router() {
        return this.router;
    }

    private boolean pathMatches(String mountPoint, RoutingContext ctx) {
        String requestPath;
        String thePath;
        String string = thePath = mountPoint == null ? this.path : mountPoint + this.path;
        if (this.useNormalisedPath) {
            requestPath = ctx.normalisedPath();
        } else {
            requestPath = ctx.request().path();
            if (requestPath == null) {
                requestPath = "/";
            }
        }
        if (this.exactPath) {
            return this.pathMatchesExact(requestPath, thePath);
        }
        if (this.pathEndsWithSlash && (requestPath.charAt(requestPath.length() - 1) == '/' ? requestPath.equals(thePath) : thePath.regionMatches(0, requestPath, 0, requestPath.length()))) {
            return true;
        }
        return requestPath.startsWith(thePath);
    }

    private boolean pathMatchesExact(String path1, String path2) {
        int idx1 = path1.length() - 1;
        return this.pathEndsWithSlash ? (path1.charAt(idx1) == '/' ? path1.equals(path2) : path2.regionMatches(0, path1, 0, path1.length())) : (path1.charAt(idx1) != '/' ? path1.equals(path2) : path1.regionMatches(0, path2, 0, path2.length()));
    }

    private void setPath(String path) {
        if (path.charAt(path.length() - 1) != '*') {
            this.exactPath = true;
            this.path = path;
        } else {
            this.exactPath = false;
            this.path = path.substring(0, path.length() - 1);
        }
        if (path.indexOf(58) != -1) {
            this.createPatternRegex(path);
        }
        this.pathEndsWithSlash = this.path.endsWith("/");
    }

    private void setRegex(String regex) {
        this.pattern = Pattern.compile(regex);
        this.exactPath = true;
        Set<String> namedGroups = this.findNamedGroups(this.pattern.pattern());
        if (!namedGroups.isEmpty()) {
            this.namedGroupsInRegex.addAll(namedGroups);
        }
    }

    private Set<String> findNamedGroups(String path) {
        TreeSet<String> namedGroups = new TreeSet<String>();
        Matcher m = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>").matcher(path);
        while (m.find()) {
            namedGroups.add(m.group(1));
        }
        return namedGroups;
    }

    private void createPatternRegex(String path) {
        if ((path = RE_OPERATORS_NO_STAR.matcher(path).replaceAll("\\\\$1")).charAt(path.length() - 1) == '*') {
            path = path.substring(0, path.length() - 1) + "(?<rest>.*)";
            this.exactPath = false;
        } else {
            this.exactPath = true;
        }
        Matcher m = RE_TOKEN_SEARCH.matcher(path);
        StringBuffer sb = new StringBuffer();
        this.groups = new ArrayList<String>();
        int index = 0;
        while (m.find()) {
            String param = "p" + index;
            String group = m.group().substring(1);
            if (this.groups.contains(group)) {
                throw new IllegalArgumentException("Cannot use identifier " + group + " more than once in pattern string");
            }
            m.appendReplacement(sb, "(?<" + param + ">[^/]+)");
            this.groups.add(group);
            ++index;
        }
        m.appendTail(sb);
        path = sb.toString();
        this.pattern = Pattern.compile(path);
    }

    private void checkPath(String path) {
        if ("".equals(path) || path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path must start with /");
        }
    }

    int order() {
        return this.order;
    }

    private void checkAdd() {
        if (!this.added) {
            this.router.add(this);
            this.added = true;
        }
    }

    protected synchronized boolean hasNextContextHandler(RoutingContextImplBase context) {
        return context.currentRouteNextHandlerIndex() < this.contextHandlers.size();
    }

    protected synchronized boolean hasNextFailureHandler(RoutingContextImplBase context) {
        return context.currentRouteNextFailureHandlerIndex() < this.failureHandlers.size();
    }

    public void setEmptyBodyPermittedWithConsumes(boolean emptyBodyPermittedWithConsumes) {
        this.emptyBodyPermittedWithConsumes = emptyBodyPermittedWithConsumes;
    }

    private void validateMount(Router router) {
        for (Route route : router.getRoutes()) {
            String combinedPath = RE_OPERATORS_NO_STAR.matcher(this.path + (this.pathEndsWithSlash ? route.getPath().substring(1) : route.getPath())).replaceAll("\\\\$1");
            Matcher m = RE_TOKEN_SEARCH.matcher(combinedPath);
            HashSet<String> groups = new HashSet<String>();
            while (m.find()) {
                String group = m.group();
                if (groups.contains(group)) {
                    throw new IllegalStateException("Cannot use identifier " + group + " more than once in pattern string");
                }
                groups.add(group);
            }
        }
    }
}

