/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.SessionHandlerImpl;
import io.vertx.ext.web.sstore.SessionStore;

@VertxGen
public interface SessionHandler
extends Handler<RoutingContext> {
    public static final String DEFAULT_SESSION_COOKIE_NAME = "vertx-web.session";
    public static final String DEFAULT_SESSION_COOKIE_PATH = "/";
    public static final long DEFAULT_SESSION_TIMEOUT = 1800000L;
    public static final boolean DEFAULT_NAG_HTTPS = true;
    public static final boolean DEFAULT_COOKIE_HTTP_ONLY_FLAG = false;
    public static final boolean DEFAULT_COOKIE_SECURE_FLAG = false;
    public static final int DEFAULT_SESSIONID_MIN_LENGTH = 16;

    public static SessionHandler create(SessionStore sessionStore) {
        return new SessionHandlerImpl(DEFAULT_SESSION_COOKIE_NAME, DEFAULT_SESSION_COOKIE_PATH, 1800000L, true, false, false, 16, sessionStore);
    }

    @Fluent
    public SessionHandler setSessionTimeout(long var1);

    @Fluent
    public SessionHandler setNagHttps(boolean var1);

    @Fluent
    public SessionHandler setCookieSecureFlag(boolean var1);

    @Fluent
    public SessionHandler setCookieHttpOnlyFlag(boolean var1);

    @Fluent
    public SessionHandler setSessionCookieName(String var1);

    @Fluent
    public SessionHandler setSessionCookiePath(String var1);

    @Fluent
    public SessionHandler setMinLength(int var1);
}

