/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.ext.web.handler.impl.AuthHandlerImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public class OAuth2AuthHandlerImpl
extends AuthHandlerImpl
implements OAuth2AuthHandler {
    private static final Pattern BEARER = Pattern.compile("^Bearer$", 2);
    private final String host;
    private final String callbackPath;
    private final boolean supportJWT;
    private Route callback;
    private JsonObject extraParams = new JsonObject();

    public OAuth2AuthHandlerImpl(OAuth2Auth authProvider, String callbackURL) {
        super((AuthProvider)authProvider);
        this.supportJWT = authProvider.hasJWTToken();
        try {
            URL url = new URL(callbackURL);
            this.host = url.getProtocol() + "://" + url.getHost() + (url.getPort() == -1 ? "" : ":" + url.getPort());
            this.callbackPath = url.getPath();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void handle(RoutingContext ctx) {
        User user = ctx.user();
        if (user != null) {
            if (this.supportJWT) {
                this.authorise(user, ctx);
            } else {
                ctx.next();
            }
        } else {
            HttpServerRequest request;
            String authorization;
            if (this.supportJWT && (authorization = (request = ctx.request()).headers().get(HttpHeaders.AUTHORIZATION)) != null) {
                String[] parts = authorization.split(" ");
                if (parts.length == 2) {
                    String scheme = parts[0];
                    String credentials = parts[1];
                    if (BEARER.matcher(scheme).matches()) {
                        ((OAuth2Auth)this.authProvider).decodeToken(credentials, decodeToken -> {
                            if (decodeToken.failed()) {
                                ctx.response().putHeader("WWW-Authenticate", "Bearer error=\"invalid_token\" error_message=\"" + decodeToken.cause().getMessage() + "\"");
                                ctx.fail(401);
                                return;
                            }
                            ctx.setUser((User)decodeToken.result());
                            Session session = ctx.session();
                            if (session != null) {
                                session.regenerateId();
                            }
                            ctx.next();
                        });
                        return;
                    }
                } else {
                    ctx.response().putHeader("WWW-Authenticate", "Bearer error=\"invalid_token\"");
                    ctx.fail(401);
                    return;
                }
            }
            ctx.response().putHeader("Location", this.authURI(this.host, ctx.normalisedPath())).setStatusCode(302).end();
        }
    }

    private String authURI(String host, String redirectURL) {
        if (this.callback == null) {
            throw new NullPointerException("callback is null");
        }
        if (this.authorities.size() > 0) {
            JsonArray scopes = new JsonArray();
            for (String authority : this.authorities) {
                scopes.add(authority);
            }
            return ((OAuth2Auth)this.authProvider).authorizeURL(new JsonObject().put("redirect_uri", host + this.callback.getPath()).put("scopes", scopes).put("state", redirectURL));
        }
        return ((OAuth2Auth)this.authProvider).authorizeURL(new JsonObject().put("redirect_uri", host + this.callback.getPath()).put("state", redirectURL));
    }

    @Override
    public OAuth2AuthHandler extraParams(JsonObject extraParams) {
        this.extraParams = extraParams;
        return this;
    }

    @Override
    public OAuth2AuthHandler setupCallback(Route route) {
        this.callback = route;
        if (!"".equals(this.callbackPath)) {
            this.callback.path(this.callbackPath);
        }
        this.callback.method(HttpMethod.GET);
        route.handler((Handler<RoutingContext>)((Handler)ctx -> {
            String code = ctx.request().getParam("code");
            if (code == null) {
                ctx.fail(400);
                return;
            }
            String state = ctx.request().getParam("state");
            ((OAuth2Auth)this.authProvider).getToken(new JsonObject().put("code", code).put("redirect_uri", this.host + this.callback.getPath()).mergeIn(this.extraParams), res -> {
                if (res.failed()) {
                    ctx.fail(res.cause());
                } else {
                    ctx.setUser((User)res.result());
                    Session session = ctx.session();
                    if (session != null) {
                        session.regenerateId();
                        ctx.response().putHeader("Cache-Control", "no-cache, no-store, must-revalidate").putHeader("Pragma", "no-cache").putHeader("Expires", "0").putHeader("Location", state).setStatusCode(302).end("Redirecting to " + state + ".");
                    } else {
                        ctx.reroute(state);
                    }
                }
            });
        }));
        return this;
    }
}

