/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl.parameter;

import io.vertx.core.Future;
import io.vertx.ext.web.validation.MalformedValueException;
import io.vertx.ext.web.validation.ParameterProcessorException;
import io.vertx.ext.web.validation.RequestParameter;
import io.vertx.ext.web.validation.impl.ParameterLocation;
import io.vertx.ext.web.validation.impl.parameter.ParameterParser;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessor;
import io.vertx.ext.web.validation.impl.validator.ValueValidator;
import java.util.List;
import java.util.Map;

public class ParameterProcessorImpl
implements ParameterProcessor,
Comparable<ParameterProcessorImpl> {
    private String parameterName;
    private ParameterLocation location;
    private boolean isOptional;
    private ParameterParser parser;
    private ValueValidator validator;

    public ParameterProcessorImpl(String parameterName, ParameterLocation location, boolean isOptional, ParameterParser parser, ValueValidator validator) {
        this.parameterName = parameterName;
        this.location = location;
        this.isOptional = isOptional;
        this.parser = parser;
        this.validator = validator;
    }

    @Override
    public Future<RequestParameter> process(Map<String, List<String>> params) {
        Object json;
        try {
            json = this.parser.parseParameter(params);
        }
        catch (MalformedValueException e) {
            throw ParameterProcessorException.createParsingError(this.parameterName, this.location, e);
        }
        if (json != null) {
            return this.validator.validate(json).recover(t -> Future.failedFuture((Throwable)((Object)ParameterProcessorException.createValidationError(this.parameterName, this.location, t))));
        }
        if (!this.isOptional) {
            throw ParameterProcessorException.createMissingParameterWhenRequired(this.parameterName, this.location);
        }
        return this.validator.getDefault().map(defaultValue -> null != defaultValue ? RequestParameter.create(defaultValue) : null);
    }

    @Override
    public String getName() {
        return this.parameterName;
    }

    @Override
    public ParameterLocation getLocation() {
        return this.location;
    }

    @Override
    public int compareTo(ParameterProcessorImpl o) {
        return this.parser.compareTo(o.parser);
    }
}

