/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl.validator;

import io.vertx.core.Future;
import io.vertx.ext.web.validation.RequestParameter;
import io.vertx.ext.web.validation.impl.validator.ValueValidator;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.Schema;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.SchemaImpl;

public class SchemaValidator
implements ValueValidator {
    Schema s;

    public SchemaValidator(Schema s) {
        this.s = s;
    }

    @Override
    public Future<RequestParameter> validate(Object json) {
        if (this.s.isSync()) {
            try {
                this.s.validateSync(json);
                ((SchemaImpl)this.s).doApplyDefaultValues(json);
                return Future.succeededFuture((Object)RequestParameter.create(json));
            }
            catch (ValidationException e) {
                return Future.failedFuture((Throwable)e);
            }
        }
        return this.s.validateAsync(json).map(v -> {
            try {
                ((SchemaImpl)this.s).doApplyDefaultValues(json);
            }
            catch (NoSyncValidationException noSyncValidationException) {
                // empty catch block
            }
            return RequestParameter.create(json);
        });
    }

    @Override
    public Object getDefault() {
        return this.s.getDefaultValue();
    }
}

