/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.builder;

import io.vertx.ext.json.schema.common.dsl.ArraySchemaBuilder;
import io.vertx.ext.json.schema.common.dsl.BooleanSchemaBuilder;
import io.vertx.ext.json.schema.common.dsl.NumberSchemaBuilder;
import io.vertx.ext.json.schema.common.dsl.ObjectSchemaBuilder;
import io.vertx.ext.json.schema.common.dsl.SchemaBuilder;
import io.vertx.ext.json.schema.common.dsl.StringSchemaBuilder;
import io.vertx.ext.json.schema.common.dsl.TupleSchemaBuilder;
import io.vertx.ext.web.validation.builder.ArrayParserFactory;
import io.vertx.ext.web.validation.builder.ObjectParserFactory;
import io.vertx.ext.web.validation.builder.ParameterProcessorFactory;
import io.vertx.ext.web.validation.builder.Parsers;
import io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory;
import io.vertx.ext.web.validation.builder.TupleParserFactory;
import io.vertx.ext.web.validation.builder.impl.ValidationDSLUtils;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessorImpl;
import io.vertx.ext.web.validation.impl.parameter.SingleValueParameterParser;
import io.vertx.ext.web.validation.impl.parser.ValueParser;
import io.vertx.ext.web.validation.impl.validator.SchemaValidator;

public interface Parameters {
    public static ParameterProcessorFactory param(String parameterName, NumberSchemaBuilder schemaBuilder) {
        return (location, jsonSchemaParser) -> new ParameterProcessorImpl(parameterName, location, false, new SingleValueParameterParser(parameterName, schemaBuilder.isIntegerSchema() ? ValueParser.LONG_PARSER : ValueParser.DOUBLE_PARSER), new SchemaValidator(schemaBuilder.build(jsonSchemaParser)));
    }

    public static ParameterProcessorFactory optionalParam(String parameterName, NumberSchemaBuilder schemaBuilder) {
        return (location, jsonSchemaParser) -> new ParameterProcessorImpl(parameterName, location, true, new SingleValueParameterParser(parameterName, schemaBuilder.isIntegerSchema() ? ValueParser.LONG_PARSER : ValueParser.DOUBLE_PARSER), new SchemaValidator(schemaBuilder.build(jsonSchemaParser)));
    }

    public static ParameterProcessorFactory param(String parameterName, StringSchemaBuilder schemaBuilder) {
        return (location, jsonSchemaParser) -> new ParameterProcessorImpl(parameterName, location, false, new SingleValueParameterParser(parameterName, ValueParser.NOOP_PARSER), new SchemaValidator(schemaBuilder.build(jsonSchemaParser)));
    }

    public static ParameterProcessorFactory optionalParam(String parameterName, StringSchemaBuilder schemaBuilder) {
        return (location, jsonSchemaParser) -> new ParameterProcessorImpl(parameterName, location, true, new SingleValueParameterParser(parameterName, ValueParser.NOOP_PARSER), new SchemaValidator(schemaBuilder.build(jsonSchemaParser)));
    }

    public static ParameterProcessorFactory param(String parameterName, BooleanSchemaBuilder schemaBuilder) {
        return (location, jsonSchemaParser) -> new ParameterProcessorImpl(parameterName, location, false, new SingleValueParameterParser(parameterName, ValueParser.BOOLEAN_PARSER), new SchemaValidator(schemaBuilder.build(jsonSchemaParser)));
    }

    public static ParameterProcessorFactory optionalParam(String parameterName, BooleanSchemaBuilder schemaBuilder) {
        return (location, jsonSchemaParser) -> new ParameterProcessorImpl(parameterName, location, true, new SingleValueParameterParser(parameterName, ValueParser.BOOLEAN_PARSER), new SchemaValidator(schemaBuilder.build(jsonSchemaParser)));
    }

    public static ParameterProcessorFactory param(String parameterName, ArraySchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createArrayParamFactory(parameterName, Parsers.commaSeparatedArrayParser(), schemaBuilder, false)::apply;
    }

    public static ParameterProcessorFactory optionalParam(String parameterName, ArraySchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createArrayParamFactory(parameterName, Parsers.commaSeparatedArrayParser(), schemaBuilder, true)::apply;
    }

    public static ParameterProcessorFactory param(String parameterName, TupleSchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createTupleParamFactory(parameterName, Parsers.commaSeparatedTupleParser(), schemaBuilder, false)::apply;
    }

    public static ParameterProcessorFactory optionalParam(String parameterName, TupleSchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createTupleParamFactory(parameterName, Parsers.commaSeparatedTupleParser(), schemaBuilder, true)::apply;
    }

    public static ParameterProcessorFactory param(String parameterName, ObjectSchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createObjectParamFactory(parameterName, Parsers.commaSeparatedObjectParser(), schemaBuilder, false)::apply;
    }

    public static ParameterProcessorFactory optionalParam(String parameterName, ObjectSchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createObjectParamFactory(parameterName, Parsers.commaSeparatedObjectParser(), schemaBuilder, true)::apply;
    }

    public static ParameterProcessorFactory param(String parameterName, SchemaBuilder schemaBuilder, ValueParser<String> valueParser) {
        return (location, jsonSchemaParser) -> new ParameterProcessorImpl(parameterName, location, false, new SingleValueParameterParser(parameterName, valueParser), new SchemaValidator(schemaBuilder.build(jsonSchemaParser)));
    }

    public static ParameterProcessorFactory optionalParam(String parameterName, SchemaBuilder schemaBuilder, ValueParser<String> valueParser) {
        return (location, jsonSchemaParser) -> new ParameterProcessorImpl(parameterName, location, true, new SingleValueParameterParser(parameterName, valueParser), new SchemaValidator(schemaBuilder.build(jsonSchemaParser)));
    }

    public static StyledParameterProcessorFactory jsonParam(String parameterName, SchemaBuilder builder) {
        return (location, parser) -> new ParameterProcessorImpl(parameterName, location, false, new SingleValueParameterParser(parameterName, ValueParser.JSON_PARSER), new SchemaValidator(builder.build(parser)));
    }

    public static StyledParameterProcessorFactory optionalJsonParam(String parameterName, SchemaBuilder builder) {
        return (location, parser) -> new ParameterProcessorImpl(parameterName, location, true, new SingleValueParameterParser(parameterName, ValueParser.JSON_PARSER), new SchemaValidator(builder.build(parser)));
    }

    public static StyledParameterProcessorFactory serializedParam(String parameterName, ArrayParserFactory arrayParserFactory, ArraySchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createArrayParamFactory(parameterName, arrayParserFactory, schemaBuilder, false)::apply;
    }

    public static StyledParameterProcessorFactory optionalSerializedParam(String parameterName, ArrayParserFactory arrayParserFactory, ArraySchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createArrayParamFactory(parameterName, arrayParserFactory, schemaBuilder, true)::apply;
    }

    public static StyledParameterProcessorFactory serializedParam(String parameterName, TupleParserFactory tupleParserFactory, TupleSchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createTupleParamFactory(parameterName, tupleParserFactory, schemaBuilder, false)::apply;
    }

    public static StyledParameterProcessorFactory optionalSerializedParam(String parameterName, TupleParserFactory tupleParserFactory, TupleSchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createTupleParamFactory(parameterName, tupleParserFactory, schemaBuilder, true)::apply;
    }

    public static StyledParameterProcessorFactory serializedParam(String parameterName, ObjectParserFactory objectParserFactory, ObjectSchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createObjectParamFactory(parameterName, objectParserFactory, schemaBuilder, false)::apply;
    }

    public static StyledParameterProcessorFactory optionalSerializedParam(String parameterName, ObjectParserFactory objectParserFactory, ObjectSchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createObjectParamFactory(parameterName, objectParserFactory, schemaBuilder, true)::apply;
    }

    public static StyledParameterProcessorFactory explodedParam(String parameterName, ArraySchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createExplodedArrayParamFactory(parameterName, schemaBuilder, false);
    }

    public static StyledParameterProcessorFactory optionalExplodedParam(String parameterName, ArraySchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createExplodedArrayParamFactory(parameterName, schemaBuilder, true);
    }

    public static StyledParameterProcessorFactory explodedParam(String parameterName, TupleSchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createExplodedTupleParamFactory(parameterName, schemaBuilder, false);
    }

    public static StyledParameterProcessorFactory optionalExplodedParam(String parameterName, TupleSchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createExplodedTupleParamFactory(parameterName, schemaBuilder, true);
    }

    public static StyledParameterProcessorFactory explodedParam(String parameterName, ObjectSchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createExplodedObjectParamFactory(parameterName, schemaBuilder, false);
    }

    public static StyledParameterProcessorFactory optionalExplodedParam(String parameterName, ObjectSchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createExplodedObjectParamFactory(parameterName, schemaBuilder, true);
    }

    public static StyledParameterProcessorFactory deepObjectParam(String parameterName, ObjectSchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createDeepObjectParamFactory(parameterName, schemaBuilder, false);
    }

    public static StyledParameterProcessorFactory optionalDeepObjectParam(String parameterName, ObjectSchemaBuilder schemaBuilder) {
        return ValidationDSLUtils.createDeepObjectParamFactory(parameterName, schemaBuilder, true);
    }
}

