/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.router.internal.handler;

import io.vertx.core.Future;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.openapi.router.internal.handler.ResponseValidationHandler;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.validation.ResponseValidator;
import io.vertx.openapi.validation.ValidatableResponse;
import io.vertx.openapi.validation.ValidatedRequest;

public abstract class EventbusHandler
extends ResponseValidationHandler {
    private final EventBus eventBus;
    private final String address;
    private final DeliveryOptions deliveryOptions;

    protected EventbusHandler(EventBus eventBus, String address, DeliveryOptions deliveryOptions, ResponseValidator validator) {
        super(validator);
        this.eventBus = eventBus;
        this.address = address;
        this.deliveryOptions = deliveryOptions;
    }

    @Override
    Future<ValidatableResponse> processRequest(ValidatedRequest request, Operation operation, RoutingContext routingContext) {
        return this.transformRequest(request, routingContext, operation).compose(payload -> this.eventBus.request(this.address, payload, this.deliveryOptions)).compose(ebResponse -> this.transformResponse((Message<JsonObject>)ebResponse, operation));
    }

    protected abstract Future<JsonObject> transformRequest(ValidatedRequest var1, RoutingContext var2, Operation var3);

    protected abstract Future<ValidatableResponse> transformResponse(Message<JsonObject> var1, Operation var2);
}

