/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.router.impl;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.InputTrustHandler;
import io.vertx.ext.web.openapi.router.OpenAPIRoute;
import io.vertx.ext.web.openapi.router.RequestExtractor;
import io.vertx.ext.web.openapi.router.RouterBuilder;
import io.vertx.ext.web.openapi.router.Security;
import io.vertx.ext.web.openapi.router.impl.AuthenticationHandlers;
import io.vertx.ext.web.openapi.router.impl.OpenAPIRouteImpl;
import io.vertx.ext.web.openapi.router.impl.RouterBuilderInternal;
import io.vertx.ext.web.openapi.router.impl.SecurityImpl;
import io.vertx.openapi.contract.OpenAPIContract;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.contract.Path;
import io.vertx.openapi.validation.RequestValidator;
import io.vertx.openapi.validation.ValidatorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class RouterBuilderImpl
implements RouterBuilderInternal {
    private static final Logger LOG = LoggerFactory.getLogger(RouterBuilderImpl.class);
    private static final String PATH_PARAM_PLACEHOLDER_REGEX = "\\{(.*?)}";
    final List<Handler<RoutingContext>> rootHandlers = new ArrayList<Handler<RoutingContext>>();
    final AuthenticationHandlers securityHandlers = new AuthenticationHandlers();
    private final Vertx vertx;
    private final OpenAPIContract contract;
    private final Map<String, OpenAPIRoute> openAPIRoutes;
    private final RequestExtractor extractor;

    public RouterBuilderImpl(Vertx vertx, OpenAPIContract contract, RequestExtractor extractor) {
        this.vertx = vertx;
        this.contract = contract;
        this.extractor = extractor;
        this.openAPIRoutes = contract.operations().stream().collect(Collectors.toMap(Operation::getOperationId, OpenAPIRouteImpl::new));
    }

    public List<Handler<RoutingContext>> rootHandlers() {
        return this.rootHandlers;
    }

    public static String toVertxWebPath(String openAPIPath) {
        return openAPIPath.replaceAll(PATH_PARAM_PLACEHOLDER_REGEX, ":$1");
    }

    @Override
    public @Nullable OpenAPIRoute getRoute(String operationId) {
        return this.openAPIRoutes.get(operationId);
    }

    @Override
    public List<OpenAPIRoute> getRoutes() {
        return new ArrayList<OpenAPIRoute>(this.openAPIRoutes.values());
    }

    @Override
    public RouterBuilder rootHandler(Handler<RoutingContext> rootHandler) {
        this.rootHandlers.add(rootHandler);
        return this;
    }

    @Override
    public RouterBuilder security(String securitySchemeName, AuthenticationHandler authenticationHandler, String callback) {
        this.securityHandlers.addRequirement(securitySchemeName, authenticationHandler, callback);
        return this;
    }

    @Override
    public Security security(String securitySchemeName) {
        return new SecurityImpl(this, this.contract.securityScheme(securitySchemeName), securitySchemeName);
    }

    @Override
    public Router createRouter() {
        Router router = Router.router((Vertx)this.vertx);
        RequestValidator validator = RequestValidator.create((Vertx)this.vertx, (OpenAPIContract)this.contract);
        Route globalRoute = router.route();
        this.rootHandlers.forEach(arg_0 -> ((Route)globalRoute).handler(arg_0));
        this.securityHandlers.applyCallbackHandlers(router);
        for (Path path : this.contract.getPaths()) {
            for (Operation operation : path.getOperations()) {
                Route route = router.route(operation.getHttpMethod(), RouterBuilderImpl.toVertxWebPath(path.getName()));
                route.putMetadata("openApiOperation", (Object)operation);
                OpenAPIRoute openAPIRoute = this.getRoute(operation.getOperationId());
                Objects.requireNonNull(openAPIRoute, "No route found for operation " + operation.getOperationId());
                if (openAPIRoute.getHandlers().size() > 0 || openAPIRoute.getFailureHandlers().size() > 0) {
                    this.securityHandlers.solve(operation, route, openAPIRoute.doSecurity());
                    if (openAPIRoute.doValidation()) {
                        InputTrustHandler validationHandler = rc -> this.extractor.extractValidatableRequest((RoutingContext)rc, operation).compose(validatableRequest -> validator.validate(validatableRequest, operation.getOperationId())).onSuccess(rp -> {
                            rc.put("openApiValidatedRequest", rp);
                            rc.next();
                        }).onFailure(e -> {
                            if (e instanceof ValidatorException) {
                                rc.fail((Throwable)new HttpException(HttpResponseStatus.BAD_REQUEST.code(), e.getMessage(), e));
                            } else {
                                rc.fail(e);
                            }
                        });
                        route.handler((Handler)validationHandler);
                    }
                    openAPIRoute.getHandlers().forEach(arg_0 -> ((Route)route).handler(arg_0));
                    openAPIRoute.getFailureHandlers().forEach(arg_0 -> ((Route)route).failureHandler(arg_0));
                    continue;
                }
                LOG.warn((Object)("No handlers found for operation " + operation.getOperationId() + " - skipping route creation"));
                route.handler(ctx -> ctx.response().setStatusCode(503).end());
            }
        }
        return router;
    }
}

