/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.router;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.openapi.router.OpenAPIRoute;
import io.vertx.ext.web.openapi.router.RequestExtractor;
import io.vertx.ext.web.openapi.router.impl.RouterBuilderImpl;
import io.vertx.openapi.contract.OpenAPIContract;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.validation.RequestUtils;
import java.util.List;

@VertxGen
public interface RouterBuilder {
    public static final String KEY_META_DATA_OPERATION = "openApiOperationId";
    public static final String KEY_META_DATA_VALIDATED_REQUEST = "openApiValidatedRequest";

    public static RouterBuilder create(Vertx vertx, OpenAPIContract contract) {
        return new RouterBuilderImpl(vertx, contract, (routingContext, operation) -> RequestUtils.extract((HttpServerRequest)routingContext.request(), (Operation)operation));
    }

    public static RouterBuilder create(Vertx vertx, OpenAPIContract contract, RequestExtractor extractor) {
        return new RouterBuilderImpl(vertx, contract, extractor);
    }

    public @Nullable OpenAPIRoute getRoute(String var1);

    public List<OpenAPIRoute> getRoutes();

    @Fluent
    public RouterBuilder rootHandler(Handler<RoutingContext> var1);

    public Router createRouter();
}

