/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.router.impl;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.InputTrustHandler;
import io.vertx.ext.web.openapi.router.OpenAPIRoute;
import io.vertx.ext.web.openapi.router.RequestExtractor;
import io.vertx.ext.web.openapi.router.RouterBuilder;
import io.vertx.ext.web.openapi.router.impl.OpenAPIRouteImpl;
import io.vertx.openapi.contract.OpenAPIContract;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.contract.Path;
import io.vertx.openapi.validation.RequestValidator;
import io.vertx.openapi.validation.impl.RequestValidatorImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RouterBuilderImpl
implements RouterBuilder {
    private static final String PATH_PARAM_PLACEHOLDER_REGEX = "\\{(.*?)}";
    final List<Handler<RoutingContext>> rootHandlers = new ArrayList<Handler<RoutingContext>>();
    private final Vertx vertx;
    private final OpenAPIContract contract;
    private final Map<String, OpenAPIRoute> openAPIRoutes;
    private final RequestExtractor extractor;

    public RouterBuilderImpl(Vertx vertx, OpenAPIContract contract, RequestExtractor extractor) {
        this.vertx = vertx;
        this.contract = contract;
        this.extractor = extractor;
        this.openAPIRoutes = contract.operations().stream().collect(Collectors.toMap(Operation::getOperationId, OpenAPIRouteImpl::new));
    }

    static String toVertxWebPath(String openAPIPath) {
        return openAPIPath.replaceAll(PATH_PARAM_PLACEHOLDER_REGEX, ":$1");
    }

    @Override
    public @Nullable OpenAPIRoute getRoute(String operationId) {
        return this.openAPIRoutes.get(operationId);
    }

    @Override
    public List<OpenAPIRoute> getRoutes() {
        return new ArrayList<OpenAPIRoute>(this.openAPIRoutes.values());
    }

    @Override
    @Fluent
    public RouterBuilder rootHandler(Handler<RoutingContext> rootHandler) {
        this.rootHandlers.add(rootHandler);
        return this;
    }

    @Override
    public Router createRouter() {
        Router router = Router.router((Vertx)this.vertx);
        RequestValidatorImpl validator = new RequestValidatorImpl(this.vertx, this.contract);
        Route globalRoute = router.route();
        this.rootHandlers.forEach(arg_0 -> ((Route)globalRoute).handler(arg_0));
        for (Path path : this.contract.getPaths()) {
            for (Operation operation : path.getOperations()) {
                Route route = router.route(operation.getHttpMethod(), RouterBuilderImpl.toVertxWebPath(path.getName()));
                route.putMetadata("openApiOperationId", (Object)operation.getOperationId());
                OpenAPIRoute openAPIRoute = this.getRoute(operation.getOperationId());
                if (openAPIRoute.doValidation()) {
                    InputTrustHandler validationHandler = arg_0 -> this.lambda$createRouter$2(operation, (RequestValidator)validator, arg_0);
                    route.handler((Handler)validationHandler);
                }
                openAPIRoute.getHandlers().forEach(arg_0 -> ((Route)route).handler(arg_0));
                openAPIRoute.getFailureHandlers().forEach(arg_0 -> ((Route)route).failureHandler(arg_0));
            }
        }
        return router;
    }

    private /* synthetic */ void lambda$createRouter$2(Operation operation, RequestValidator validator, RoutingContext rc) {
        this.extractor.extractValidatableRequest(rc, operation).compose(validatableRequest -> validator.validate(validatableRequest, operation.getOperationId())).onSuccess(rp -> {
            rc.put("openApiValidatedRequest", rp);
            rc.next();
        }).onFailure(arg_0 -> ((RoutingContext)rc).fail(arg_0));
    }
}

