/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql.instrumentation;

import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.LightDataFetcher;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.SingletonPropertyDataFetcher;
import io.vertx.core.json.JsonObject;
import java.util.function.Supplier;

public class JsonObjectAdapter
extends SimplePerformantInstrumentation {
    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        if (dataFetcher instanceof SingletonPropertyDataFetcher) {
            return JsonObjectCompatible.FOR_SINGLETON_FETCHER;
        }
        if (dataFetcher instanceof PropertyDataFetcher) {
            PropertyDataFetcher fetcher = (PropertyDataFetcher)dataFetcher;
            return new JsonObjectCompatible((LightDataFetcher<?>)fetcher);
        }
        return dataFetcher;
    }

    private static class JsonObjectCompatible
    implements LightDataFetcher<Object> {
        static final JsonObjectCompatible FOR_SINGLETON_FETCHER = new JsonObjectCompatible(SingletonPropertyDataFetcher.singleton());
        final LightDataFetcher<?> delegate;

        JsonObjectCompatible(LightDataFetcher<?> delegate) {
            this.delegate = delegate;
        }

        public Object get(GraphQLFieldDefinition fieldDefinition, Object sourceObject, Supplier<DataFetchingEnvironment> environmentSupplier) throws Exception {
            if (sourceObject instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)sourceObject;
                return this.delegate.get(fieldDefinition, (Object)jsonObject.getMap(), environmentSupplier);
            }
            return this.delegate.get(fieldDefinition, sourceObject, environmentSupplier);
        }

        public Object get(DataFetchingEnvironment environment) throws Exception {
            return this.get(environment.getFieldDefinition(), environment.getSource(), () -> environment);
        }
    }
}

