/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql.instrumentation;

import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.LightDataFetcher;
import graphql.schema.PropertyDataFetcher;
import io.vertx.core.json.JsonObject;
import java.util.function.Supplier;

public class JsonObjectAdapter
extends SimplePerformantInstrumentation {
    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        if (dataFetcher instanceof PropertyDataFetcher) {
            PropertyDataFetcher fetcher = (PropertyDataFetcher)dataFetcher;
            return new JsonObjectCompatible(fetcher);
        }
        return dataFetcher;
    }

    private static class JsonObjectCompatible
    implements LightDataFetcher<Object> {
        final PropertyDataFetcher<?> propertyDataFetcher;

        JsonObjectCompatible(PropertyDataFetcher<?> propertyDataFetcher) {
            this.propertyDataFetcher = propertyDataFetcher;
        }

        public Object get(GraphQLFieldDefinition fieldDefinition, Object sourceObject, Supplier<DataFetchingEnvironment> environmentSupplier) throws Exception {
            if (sourceObject instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)sourceObject;
                return this.propertyDataFetcher.get(fieldDefinition, (Object)jsonObject.getMap(), environmentSupplier);
            }
            return this.propertyDataFetcher.get(fieldDefinition, sourceObject, environmentSupplier);
        }

        public Object get(DataFetchingEnvironment environment) throws Exception {
            return this.get(environment.getFieldDefinition(), environment.getSource(), () -> environment);
        }
    }
}

