/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql.impl.ws;

import graphql.GraphQL;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.impl.ContextInternal;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext;
import io.vertx.ext.web.handler.graphql.impl.ws.ConnectionHandler;
import io.vertx.ext.web.handler.graphql.ws.ConnectionInitEvent;
import io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler;
import io.vertx.ext.web.handler.graphql.ws.GraphQLWSOptions;
import io.vertx.ext.web.handler.graphql.ws.Message;
import io.vertx.ext.web.impl.Utils;

public class GraphQLWSHandlerImpl
implements GraphQLWSHandler {
    private final GraphQL graphQL;
    private final long connectionInitWaitTimeout;
    private Handler<ExecutionInputBuilderWithContext<Message>> beforeExecute;
    private Handler<ConnectionInitEvent> connectionInitHandler;
    private Handler<Message> messageHandler;
    private Handler<ServerWebSocket> endHandler;

    public GraphQLWSHandlerImpl(GraphQL graphQL, GraphQLWSOptions options) {
        this.graphQL = graphQL;
        this.connectionInitWaitTimeout = options == null ? 3000L : options.getConnectionInitWaitTimeout();
    }

    GraphQL getGraphQL() {
        return this.graphQL;
    }

    long getConnectionInitWaitTimeout() {
        return this.connectionInitWaitTimeout;
    }

    @Override
    public GraphQLWSHandler connectionInitHandler(Handler<ConnectionInitEvent> connectionInitHandler) {
        this.connectionInitHandler = connectionInitHandler;
        return this;
    }

    synchronized Handler<ConnectionInitEvent> getConnectionInitHandler() {
        return this.connectionInitHandler;
    }

    @Override
    public GraphQLWSHandler beforeExecute(Handler<ExecutionInputBuilderWithContext<Message>> beforeExecute) {
        this.beforeExecute = beforeExecute;
        return this;
    }

    synchronized Handler<ExecutionInputBuilderWithContext<Message>> getBeforeExecute() {
        return this.beforeExecute;
    }

    @Override
    public synchronized GraphQLWSHandler messageHandler(Handler<Message> messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    synchronized Handler<Message> getMessageHandler() {
        return this.messageHandler;
    }

    @Override
    public synchronized GraphQLWSHandler endHandler(Handler<ServerWebSocket> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    synchronized Handler<ServerWebSocket> getEndHandler() {
        return this.endHandler;
    }

    public void handle(RoutingContext rc) {
        if (Utils.canUpgradeToWebsocket((HttpServerRequest)rc.request())) {
            ContextInternal context = (ContextInternal)rc.vertx().getOrCreateContext();
            rc.request().toWebSocket().onFailure(arg_0 -> ((RoutingContext)rc).fail(arg_0)).onSuccess(socket -> {
                ConnectionHandler handler = new ConnectionHandler(this, context, (ServerWebSocket)socket, rc);
                handler.handleConnection();
            });
        } else {
            rc.next();
        }
    }
}

